<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resultado ServiceType
 * @subpackage Services
 */
class Resultado extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resultadoExamesPorFuncionarioFicha
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResultadoExamesPorFuncionarioFicha $parameters
     * @return \StructType\ResultadoExamesPorFuncionarioFichaResponse|bool
     */
    public function resultadoExamesPorFuncionarioFicha(\StructType\ResultadoExamesPorFuncionarioFicha $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->resultadoExamesPorFuncionarioFicha($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resultadoExamesPorCodigoSequencial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResultadoExamesPorCodigoSequencial $parameters
     * @return \StructType\ResultadoExamesPorCodigoSequencialResponse|bool
     */
    public function resultadoExamesPorCodigoSequencial(\StructType\ResultadoExamesPorCodigoSequencial $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->resultadoExamesPorCodigoSequencial($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResultadoExamesPorCodigoSequencialResponse|\StructType\ResultadoExamesPorFuncionarioFichaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
