<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Inclui ServiceType
 * @subpackage Services
 */
class Inclui extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named incluiDadosAso
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluiDadosAso $parameters
     * @return \StructType\IncluiDadosAsoResponse|bool
     */
    public function incluiDadosAso(\StructType\IncluiDadosAso $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->incluiDadosAso($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IncluiDadosAsoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
