<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Exporta ServiceType
 * @subpackage Services
 */
class Exporta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named exportaDadosWs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportaDadosWs $parameters
     * @return \StructType\ExportaDadosWsResponse|bool
     */
    public function exportaDadosWs(\StructType\ExportaDadosWs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->exportaDadosWs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExportaDadosWsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
