<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendRecapiti $parameters
     * @return \StructType\SendRecapitiResponse|bool
     */
    public function SendRecapiti(\StructType\SendRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCorsoRegistrazione $parameters
     * @return \StructType\SendCorsoRegistrazioneResponse|bool
     */
    public function SendCorsoRegistrazione(\StructType\SendCorsoRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoCancellaRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCorsoCancellaRegistrazione $parameters
     * @return \StructType\SendCorsoCancellaRegistrazioneResponse|bool
     */
    public function SendCorsoCancellaRegistrazione(\StructType\SendCorsoCancellaRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoCancellaRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSegnalazioneGuasto $parameters
     * @return \StructType\SendSegnalazioneGuastoResponse|bool
     */
    public function SendSegnalazioneGuasto(\StructType\SendSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendCorsoCancellaRegistrazioneResponse|\StructType\SendCorsoRegistrazioneResponse|\StructType\SendRecapitiResponse|\StructType\SendSegnalazioneGuastoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
