<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Iscrizione ServiceType
 * @subpackage Services
 */
class Iscrizione extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IscrizioneTurno $parameters
     * @return \StructType\IscrizioneTurnoResponse|bool
     */
    public function IscrizioneTurno(\StructType\IscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IscrizioneTurno2 $parameters
     * @return \StructType\IscrizioneTurno2Response|bool
     */
    public function IscrizioneTurno2(\StructType\IscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IscrizioneEvento $parameters
     * @return \StructType\IscrizioneEventoResponse|bool
     */
    public function IscrizioneEvento(\StructType\IscrizioneEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IscrizioneEventoResponse|\StructType\IscrizioneTurno2Response|\StructType\IscrizioneTurnoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
