<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAttivita StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TAttivita
 * @subpackage Structs
 */
class TAttivita extends AttivitaModel
{
    /**
     * The NumMaxPersonale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMaxPersonale;
    /**
     * The NumMinPersonale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMinPersonale;
    /**
     * The Partecipanti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTPartecipante
     */
    public $Partecipanti;
    /**
     * The Richiesta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Richiesta;
    /**
     * Constructor method for TAttivita
     * @uses TAttivita::setNumMaxPersonale()
     * @uses TAttivita::setNumMinPersonale()
     * @uses TAttivita::setPartecipanti()
     * @uses TAttivita::setRichiesta()
     * @param int $numMaxPersonale
     * @param int $numMinPersonale
     * @param \ArrayType\ArrayOfTPartecipante $partecipanti
     * @param bool $richiesta
     */
    public function __construct($numMaxPersonale = null, $numMinPersonale = null, \ArrayType\ArrayOfTPartecipante $partecipanti = null, $richiesta = null)
    {
        $this
            ->setNumMaxPersonale($numMaxPersonale)
            ->setNumMinPersonale($numMinPersonale)
            ->setPartecipanti($partecipanti)
            ->setRichiesta($richiesta);
    }
    /**
     * Get NumMaxPersonale value
     * @return int|null
     */
    public function getNumMaxPersonale()
    {
        return $this->NumMaxPersonale;
    }
    /**
     * Set NumMaxPersonale value
     * @param int $numMaxPersonale
     * @return \StructType\TAttivita
     */
    public function setNumMaxPersonale($numMaxPersonale = null)
    {
        // validation for constraint: int
        if (!is_null($numMaxPersonale) && !(is_int($numMaxPersonale) || ctype_digit($numMaxPersonale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMaxPersonale, true), gettype($numMaxPersonale)), __LINE__);
        }
        $this->NumMaxPersonale = $numMaxPersonale;
        return $this;
    }
    /**
     * Get NumMinPersonale value
     * @return int|null
     */
    public function getNumMinPersonale()
    {
        return $this->NumMinPersonale;
    }
    /**
     * Set NumMinPersonale value
     * @param int $numMinPersonale
     * @return \StructType\TAttivita
     */
    public function setNumMinPersonale($numMinPersonale = null)
    {
        // validation for constraint: int
        if (!is_null($numMinPersonale) && !(is_int($numMinPersonale) || ctype_digit($numMinPersonale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMinPersonale, true), gettype($numMinPersonale)), __LINE__);
        }
        $this->NumMinPersonale = $numMinPersonale;
        return $this;
    }
    /**
     * Get Partecipanti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTPartecipante|null
     */
    public function getPartecipanti()
    {
        return isset($this->Partecipanti) ? $this->Partecipanti : null;
    }
    /**
     * Set Partecipanti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTPartecipante $partecipanti
     * @return \StructType\TAttivita
     */
    public function setPartecipanti(\ArrayType\ArrayOfTPartecipante $partecipanti = null)
    {
        if (is_null($partecipanti) || (is_array($partecipanti) && empty($partecipanti))) {
            unset($this->Partecipanti);
        } else {
            $this->Partecipanti = $partecipanti;
        }
        return $this;
    }
    /**
     * Get Richiesta value
     * @return bool|null
     */
    public function getRichiesta()
    {
        return $this->Richiesta;
    }
    /**
     * Set Richiesta value
     * @param bool $richiesta
     * @return \StructType\TAttivita
     */
    public function setRichiesta($richiesta = null)
    {
        // validation for constraint: boolean
        if (!is_null($richiesta) && !is_bool($richiesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($richiesta, true), gettype($richiesta)), __LINE__);
        }
        $this->Richiesta = $richiesta;
        return $this;
    }
}
