<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recapito StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Recapito
 * @subpackage Structs
 */
class Recapito extends AbstractStructBase
{
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The IDTipologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDTipologia;
    /**
     * The Prefisso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefisso;
    /**
     * The Telefono
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefono;
    /**
     * Constructor method for Recapito
     * @uses Recapito::setDescrizione()
     * @uses Recapito::setIDTipologia()
     * @uses Recapito::setPrefisso()
     * @uses Recapito::setTelefono()
     * @param string $descrizione
     * @param int $iDTipologia
     * @param string $prefisso
     * @param string $telefono
     */
    public function __construct($descrizione = null, $iDTipologia = null, $prefisso = null, $telefono = null)
    {
        $this
            ->setDescrizione($descrizione)
            ->setIDTipologia($iDTipologia)
            ->setPrefisso($prefisso)
            ->setTelefono($telefono);
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\Recapito
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get IDTipologia value
     * @return int|null
     */
    public function getIDTipologia()
    {
        return $this->IDTipologia;
    }
    /**
     * Set IDTipologia value
     * @param int $iDTipologia
     * @return \StructType\Recapito
     */
    public function setIDTipologia($iDTipologia = null)
    {
        // validation for constraint: int
        if (!is_null($iDTipologia) && !(is_int($iDTipologia) || ctype_digit($iDTipologia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTipologia, true), gettype($iDTipologia)), __LINE__);
        }
        $this->IDTipologia = $iDTipologia;
        return $this;
    }
    /**
     * Get Prefisso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefisso()
    {
        return isset($this->Prefisso) ? $this->Prefisso : null;
    }
    /**
     * Set Prefisso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefisso
     * @return \StructType\Recapito
     */
    public function setPrefisso($prefisso = null)
    {
        // validation for constraint: string
        if (!is_null($prefisso) && !is_string($prefisso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefisso, true), gettype($prefisso)), __LINE__);
        }
        if (is_null($prefisso) || (is_array($prefisso) && empty($prefisso))) {
            unset($this->Prefisso);
        } else {
            $this->Prefisso = $prefisso;
        }
        return $this;
    }
    /**
     * Get Telefono value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefono()
    {
        return isset($this->Telefono) ? $this->Telefono : null;
    }
    /**
     * Set Telefono value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefono
     * @return \StructType\Recapito
     */
    public function setTelefono($telefono = null)
    {
        // validation for constraint: string
        if (!is_null($telefono) && !is_string($telefono)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefono, true), gettype($telefono)), __LINE__);
        }
        if (is_null($telefono) || (is_array($telefono) && empty($telefono))) {
            unset($this->Telefono);
        } else {
            $this->Telefono = $telefono;
        }
        return $this;
    }
}
