<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Qualifica StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Qualifica
 * @subpackage Structs
 */
class Qualifica extends AbstractStructBase
{
    /**
     * The DataFineValidita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataFineValidita;
    /**
     * The DataInizioValidita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataInizioValidita;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IDTipologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDTipologia;
    /**
     * The ResponsabileTurno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResponsabileTurno;
    /**
     * Constructor method for Qualifica
     * @uses Qualifica::setDataFineValidita()
     * @uses Qualifica::setDataInizioValidita()
     * @uses Qualifica::setDescrizione()
     * @uses Qualifica::setID()
     * @uses Qualifica::setIDTipologia()
     * @uses Qualifica::setResponsabileTurno()
     * @param string $dataFineValidita
     * @param string $dataInizioValidita
     * @param string $descrizione
     * @param int $iD
     * @param int $iDTipologia
     * @param int $responsabileTurno
     */
    public function __construct($dataFineValidita = null, $dataInizioValidita = null, $descrizione = null, $iD = null, $iDTipologia = null, $responsabileTurno = null)
    {
        $this
            ->setDataFineValidita($dataFineValidita)
            ->setDataInizioValidita($dataInizioValidita)
            ->setDescrizione($descrizione)
            ->setID($iD)
            ->setIDTipologia($iDTipologia)
            ->setResponsabileTurno($responsabileTurno);
    }
    /**
     * Get DataFineValidita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataFineValidita()
    {
        return isset($this->DataFineValidita) ? $this->DataFineValidita : null;
    }
    /**
     * Set DataFineValidita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataFineValidita
     * @return \StructType\Qualifica
     */
    public function setDataFineValidita($dataFineValidita = null)
    {
        // validation for constraint: string
        if (!is_null($dataFineValidita) && !is_string($dataFineValidita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFineValidita, true), gettype($dataFineValidita)), __LINE__);
        }
        if (is_null($dataFineValidita) || (is_array($dataFineValidita) && empty($dataFineValidita))) {
            unset($this->DataFineValidita);
        } else {
            $this->DataFineValidita = $dataFineValidita;
        }
        return $this;
    }
    /**
     * Get DataInizioValidita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataInizioValidita()
    {
        return isset($this->DataInizioValidita) ? $this->DataInizioValidita : null;
    }
    /**
     * Set DataInizioValidita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataInizioValidita
     * @return \StructType\Qualifica
     */
    public function setDataInizioValidita($dataInizioValidita = null)
    {
        // validation for constraint: string
        if (!is_null($dataInizioValidita) && !is_string($dataInizioValidita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInizioValidita, true), gettype($dataInizioValidita)), __LINE__);
        }
        if (is_null($dataInizioValidita) || (is_array($dataInizioValidita) && empty($dataInizioValidita))) {
            unset($this->DataInizioValidita);
        } else {
            $this->DataInizioValidita = $dataInizioValidita;
        }
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\Qualifica
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Qualifica
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IDTipologia value
     * @return int|null
     */
    public function getIDTipologia()
    {
        return $this->IDTipologia;
    }
    /**
     * Set IDTipologia value
     * @param int $iDTipologia
     * @return \StructType\Qualifica
     */
    public function setIDTipologia($iDTipologia = null)
    {
        // validation for constraint: int
        if (!is_null($iDTipologia) && !(is_int($iDTipologia) || ctype_digit($iDTipologia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTipologia, true), gettype($iDTipologia)), __LINE__);
        }
        $this->IDTipologia = $iDTipologia;
        return $this;
    }
    /**
     * Get ResponsabileTurno value
     * @return int|null
     */
    public function getResponsabileTurno()
    {
        return $this->ResponsabileTurno;
    }
    /**
     * Set ResponsabileTurno value
     * @param int $responsabileTurno
     * @return \StructType\Qualifica
     */
    public function setResponsabileTurno($responsabileTurno = null)
    {
        // validation for constraint: int
        if (!is_null($responsabileTurno) && !(is_int($responsabileTurno) || ctype_digit($responsabileTurno))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responsabileTurno, true), gettype($responsabileTurno)), __LINE__);
        }
        $this->ResponsabileTurno = $responsabileTurno;
        return $this;
    }
}
