<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Presenza_CheckListRispostaModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Presenza_CheckListRispostaModel
 * @subpackage Structs
 */
class Presenza_CheckListRispostaModel extends AbstractStructBase
{
    /**
     * The Esito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Esito;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IDPresenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PresenzaModel
     */
    public $IDPresenza;
    /**
     * The Richiesta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Presenza_CheckListRichiestaModel
     */
    public $Richiesta;
    /**
     * Constructor method for Presenza_CheckListRispostaModel
     * @uses Presenza_CheckListRispostaModel::setEsito()
     * @uses Presenza_CheckListRispostaModel::setID()
     * @uses Presenza_CheckListRispostaModel::setIDPresenza()
     * @uses Presenza_CheckListRispostaModel::setRichiesta()
     * @param bool $esito
     * @param int $iD
     * @param \StructType\PresenzaModel $iDPresenza
     * @param \StructType\Presenza_CheckListRichiestaModel $richiesta
     */
    public function __construct($esito = null, $iD = null, \StructType\PresenzaModel $iDPresenza = null, \StructType\Presenza_CheckListRichiestaModel $richiesta = null)
    {
        $this
            ->setEsito($esito)
            ->setID($iD)
            ->setIDPresenza($iDPresenza)
            ->setRichiesta($richiesta);
    }
    /**
     * Get Esito value
     * @return bool|null
     */
    public function getEsito()
    {
        return $this->Esito;
    }
    /**
     * Set Esito value
     * @param bool $esito
     * @return \StructType\Presenza_CheckListRispostaModel
     */
    public function setEsito($esito = null)
    {
        // validation for constraint: boolean
        if (!is_null($esito) && !is_bool($esito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esito, true), gettype($esito)), __LINE__);
        }
        $this->Esito = $esito;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Presenza_CheckListRispostaModel
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IDPresenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PresenzaModel|null
     */
    public function getIDPresenza()
    {
        return isset($this->IDPresenza) ? $this->IDPresenza : null;
    }
    /**
     * Set IDPresenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PresenzaModel $iDPresenza
     * @return \StructType\Presenza_CheckListRispostaModel
     */
    public function setIDPresenza(\StructType\PresenzaModel $iDPresenza = null)
    {
        if (is_null($iDPresenza) || (is_array($iDPresenza) && empty($iDPresenza))) {
            unset($this->IDPresenza);
        } else {
            $this->IDPresenza = $iDPresenza;
        }
        return $this;
    }
    /**
     * Get Richiesta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Presenza_CheckListRichiestaModel|null
     */
    public function getRichiesta()
    {
        return isset($this->Richiesta) ? $this->Richiesta : null;
    }
    /**
     * Set Richiesta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Presenza_CheckListRichiestaModel $richiesta
     * @return \StructType\Presenza_CheckListRispostaModel
     */
    public function setRichiesta(\StructType\Presenza_CheckListRichiestaModel $richiesta = null)
    {
        if (is_null($richiesta) || (is_array($richiesta) && empty($richiesta))) {
            unset($this->Richiesta);
        } else {
            $this->Richiesta = $richiesta;
        }
        return $this;
    }
}
