<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeightType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupWeightType extends AbstractStructBase
{
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * The UnitOfMeasurement
     * @var string
     */
    public $UnitOfMeasurement;
    /**
     * Constructor method for WeightType
     * @uses Ups_pickupWeightType::setWeight()
     * @uses Ups_pickupWeightType::setUnitOfMeasurement()
     * @param string $weight
     * @param string $unitOfMeasurement
     */
    public function __construct($weight = null, $unitOfMeasurement = null)
    {
        $this
            ->setWeight($weight)
            ->setUnitOfMeasurement($unitOfMeasurement);
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ups_pickup\upspickupStruct\Ups_pickupWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return string|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param string $unitOfMeasurement
     * @return \Ups_pickup\upspickupStruct\Ups_pickupWeightType
     */
    public function setUnitOfMeasurement($unitOfMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasurement) && !is_string($unitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasurement, true), gettype($unitOfMeasurement)), __LINE__);
        }
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
}
