<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginAddressType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupOriginAddressType extends AbstractStructBase
{
    /**
     * The StreetAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetAddress;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StateProvince;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The OriginSearchCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupOriginSearchCriteriaType
     */
    public $OriginSearchCriteria;
    /**
     * Constructor method for OriginAddressType
     * @uses Ups_pickupOriginAddressType::setStreetAddress()
     * @uses Ups_pickupOriginAddressType::setCity()
     * @uses Ups_pickupOriginAddressType::setStateProvince()
     * @uses Ups_pickupOriginAddressType::setPostalCode()
     * @uses Ups_pickupOriginAddressType::setCountryCode()
     * @uses Ups_pickupOriginAddressType::setOriginSearchCriteria()
     * @param string $streetAddress
     * @param string $city
     * @param string $stateProvince
     * @param string $postalCode
     * @param string $countryCode
     * @param \Ups_pickup\upspickupStruct\Ups_pickupOriginSearchCriteriaType $originSearchCriteria
     */
    public function __construct($streetAddress = null, $city = null, $stateProvince = null, $postalCode = null, $countryCode = null, \Ups_pickup\upspickupStruct\Ups_pickupOriginSearchCriteriaType $originSearchCriteria = null)
    {
        $this
            ->setStreetAddress($streetAddress)
            ->setCity($city)
            ->setStateProvince($stateProvince)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode)
            ->setOriginSearchCriteria($originSearchCriteria);
    }
    /**
     * Get StreetAddress value
     * @return string|null
     */
    public function getStreetAddress()
    {
        return $this->StreetAddress;
    }
    /**
     * Set StreetAddress value
     * @param string $streetAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public function setStreetAddress($streetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress) && !is_string($streetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress, true), gettype($streetAddress)), __LINE__);
        }
        $this->StreetAddress = $streetAddress;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvince value
     * @return string|null
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }
    /**
     * Set StateProvince value
     * @param string $stateProvince
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        $this->StateProvince = $stateProvince;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get OriginSearchCriteria value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginSearchCriteriaType|null
     */
    public function getOriginSearchCriteria()
    {
        return $this->OriginSearchCriteria;
    }
    /**
     * Set OriginSearchCriteria value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupOriginSearchCriteriaType $originSearchCriteria
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public function setOriginSearchCriteria(\Ups_pickup\upspickupStruct\Ups_pickupOriginSearchCriteriaType $originSearchCriteria = null)
    {
        $this->OriginSearchCriteria = $originSearchCriteria;
        return $this;
    }
}
