<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementLevelInformationType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupElementLevelInformationType extends AbstractStructBase
{
    /**
     * The Level
     * @var string
     */
    public $Level;
    /**
     * The ElementIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType[]
     */
    public $ElementIdentifier;
    /**
     * Constructor method for ElementLevelInformationType
     * @uses Ups_pickupElementLevelInformationType::setLevel()
     * @uses Ups_pickupElementLevelInformationType::setElementIdentifier()
     * @param string $level
     * @param \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType[] $elementIdentifier
     */
    public function __construct($level = null, array $elementIdentifier = array())
    {
        $this
            ->setLevel($level)
            ->setElementIdentifier($elementIdentifier);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param string $level
     * @return \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get ElementIdentifier value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType[]|null
     */
    public function getElementIdentifier()
    {
        return $this->ElementIdentifier;
    }
    /**
     * This method is responsible for validating the values passed to the setElementIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElementIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementIdentifierForArrayConstraintsFromSetElementIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $elementLevelInformationTypeElementIdentifierItem) {
            // validation for constraint: itemType
            if (!$elementLevelInformationTypeElementIdentifierItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType) {
                $invalidValues[] = is_object($elementLevelInformationTypeElementIdentifierItem) ? get_class($elementLevelInformationTypeElementIdentifierItem) : sprintf('%s(%s)', gettype($elementLevelInformationTypeElementIdentifierItem), var_export($elementLevelInformationTypeElementIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ElementIdentifier property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ElementIdentifier value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType[] $elementIdentifier
     * @return \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType
     */
    public function setElementIdentifier(array $elementIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($elementIdentifierArrayErrorMessage = self::validateElementIdentifierForArrayConstraintsFromSetElementIdentifier($elementIdentifier))) {
            throw new \InvalidArgumentException($elementIdentifierArrayErrorMessage, __LINE__);
        }
        $this->ElementIdentifier = $elementIdentifier;
        return $this;
    }
    /**
     * Add item to ElementIdentifier value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType
     */
    public function addToElementIdentifier(\Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType) {
            throw new \InvalidArgumentException(sprintf('The ElementIdentifier property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupElementIdentifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ElementIdentifier[] = $item;
        return $this;
    }
}
