<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupAccountType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountCountryCode
     * @var string
     */
    public $AccountCountryCode;
    /**
     * Constructor method for AccountType
     * @uses Ups_pickupAccountType::setAccountNumber()
     * @uses Ups_pickupAccountType::setAccountCountryCode()
     * @param string $accountNumber
     * @param string $accountCountryCode
     */
    public function __construct($accountNumber = null, $accountCountryCode = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAccountCountryCode($accountCountryCode);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAccountType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountCountryCode value
     * @return string|null
     */
    public function getAccountCountryCode()
    {
        return $this->AccountCountryCode;
    }
    /**
     * Set AccountCountryCode value
     * @param string $accountCountryCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAccountType
     */
    public function setAccountCountryCode($accountCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCountryCode) && !is_string($accountCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCountryCode, true), gettype($accountCountryCode)), __LINE__);
        }
        $this->AccountCountryCode = $accountCountryCode;
        return $this;
    }
}
