<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.ibenetos.com/ups/pickup/Pickup.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.ibenetos.com/ups/pickup/Pickup.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Ups_pickup\Ups_pickupClassMap::get(),
);
/**
 * Samples for Process ServiceType
 */
$process = new \Ups_pickup\upspickupService\Ups_pickupProcess($options);
$process->setSoapHeaderUPSSecurity(new \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity());
/**
 * Sample call for ProcessPickupCreation operation/method
 */
if ($process->ProcessPickupCreation(new \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPickupGetServiceCenterFacilities operation/method
 */
if ($process->ProcessPickupGetServiceCenterFacilities(new \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPickupRate operation/method
 */
if ($process->ProcessPickupRate(new \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPickupCancel operation/method
 */
if ($process->ProcessPickupCancel(new \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPickupPendingStatus operation/method
 */
if ($process->ProcessPickupPendingStatus(new \Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPickupGetPoliticalDivision1List operation/method
 */
if ($process->ProcessPickupGetPoliticalDivision1List(new \Ups_pickup\upspickupStruct\Ups_pickupPickupGetPoliticalDivision1ListRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
