<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentServiceOptionsType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupShipmentServiceOptionsType extends AbstractStructBase
{
    /**
     * The OriginLiftGateIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginLiftGateIndicator;
    /**
     * The DropoffAtUPSFacilityIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DropoffAtUPSFacilityIndicator;
    /**
     * The HoldForPickupIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HoldForPickupIndicator;
    /**
     * Constructor method for ShipmentServiceOptionsType
     * @uses Ups_pickupShipmentServiceOptionsType::setOriginLiftGateIndicator()
     * @uses Ups_pickupShipmentServiceOptionsType::setDropoffAtUPSFacilityIndicator()
     * @uses Ups_pickupShipmentServiceOptionsType::setHoldForPickupIndicator()
     * @param string $originLiftGateIndicator
     * @param string $dropoffAtUPSFacilityIndicator
     * @param string $holdForPickupIndicator
     */
    public function __construct($originLiftGateIndicator = null, $dropoffAtUPSFacilityIndicator = null, $holdForPickupIndicator = null)
    {
        $this
            ->setOriginLiftGateIndicator($originLiftGateIndicator)
            ->setDropoffAtUPSFacilityIndicator($dropoffAtUPSFacilityIndicator)
            ->setHoldForPickupIndicator($holdForPickupIndicator);
    }
    /**
     * Get OriginLiftGateIndicator value
     * @return string|null
     */
    public function getOriginLiftGateIndicator()
    {
        return $this->OriginLiftGateIndicator;
    }
    /**
     * Set OriginLiftGateIndicator value
     * @param string $originLiftGateIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType
     */
    public function setOriginLiftGateIndicator($originLiftGateIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($originLiftGateIndicator) && !is_string($originLiftGateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originLiftGateIndicator, true), gettype($originLiftGateIndicator)), __LINE__);
        }
        $this->OriginLiftGateIndicator = $originLiftGateIndicator;
        return $this;
    }
    /**
     * Get DropoffAtUPSFacilityIndicator value
     * @return string|null
     */
    public function getDropoffAtUPSFacilityIndicator()
    {
        return $this->DropoffAtUPSFacilityIndicator;
    }
    /**
     * Set DropoffAtUPSFacilityIndicator value
     * @param string $dropoffAtUPSFacilityIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType
     */
    public function setDropoffAtUPSFacilityIndicator($dropoffAtUPSFacilityIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($dropoffAtUPSFacilityIndicator) && !is_string($dropoffAtUPSFacilityIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropoffAtUPSFacilityIndicator, true), gettype($dropoffAtUPSFacilityIndicator)), __LINE__);
        }
        $this->DropoffAtUPSFacilityIndicator = $dropoffAtUPSFacilityIndicator;
        return $this;
    }
    /**
     * Get HoldForPickupIndicator value
     * @return string|null
     */
    public function getHoldForPickupIndicator()
    {
        return $this->HoldForPickupIndicator;
    }
    /**
     * Set HoldForPickupIndicator value
     * @param string $holdForPickupIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType
     */
    public function setHoldForPickupIndicator($holdForPickupIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($holdForPickupIndicator) && !is_string($holdForPickupIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdForPickupIndicator, true), gettype($holdForPickupIndicator)), __LINE__);
        }
        $this->HoldForPickupIndicator = $holdForPickupIndicator;
        return $this;
    }
}
