<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateResultType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupRateResultType extends AbstractStructBase
{
    /**
     * The Disclaimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupDisclaimerType
     */
    public $Disclaimer;
    /**
     * The RateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateType;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ChargeDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType[]
     */
    public $ChargeDetail;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalTax;
    /**
     * The GrandTotalOfAllCharge
     * @var string
     */
    public $GrandTotalOfAllCharge;
    /**
     * The GrandTotalOfAllIncentedCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrandTotalOfAllIncentedCharge;
    /**
     * The PreTaxTotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PreTaxTotalCharge;
    /**
     * The PreTaxTotalIncentedCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PreTaxTotalIncentedCharge;
    /**
     * Constructor method for RateResultType
     * @uses Ups_pickupRateResultType::setDisclaimer()
     * @uses Ups_pickupRateResultType::setRateType()
     * @uses Ups_pickupRateResultType::setCurrencyCode()
     * @uses Ups_pickupRateResultType::setChargeDetail()
     * @uses Ups_pickupRateResultType::setTaxCharges()
     * @uses Ups_pickupRateResultType::setTotalTax()
     * @uses Ups_pickupRateResultType::setGrandTotalOfAllCharge()
     * @uses Ups_pickupRateResultType::setGrandTotalOfAllIncentedCharge()
     * @uses Ups_pickupRateResultType::setPreTaxTotalCharge()
     * @uses Ups_pickupRateResultType::setPreTaxTotalIncentedCharge()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDisclaimerType $disclaimer
     * @param string $rateType
     * @param string $currencyCode
     * @param \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType[] $chargeDetail
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType[] $taxCharges
     * @param string $totalTax
     * @param string $grandTotalOfAllCharge
     * @param string $grandTotalOfAllIncentedCharge
     * @param string $preTaxTotalCharge
     * @param string $preTaxTotalIncentedCharge
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupDisclaimerType $disclaimer = null, $rateType = null, $currencyCode = null, array $chargeDetail = array(), array $taxCharges = array(), $totalTax = null, $grandTotalOfAllCharge = null, $grandTotalOfAllIncentedCharge = null, $preTaxTotalCharge = null, $preTaxTotalIncentedCharge = null)
    {
        $this
            ->setDisclaimer($disclaimer)
            ->setRateType($rateType)
            ->setCurrencyCode($currencyCode)
            ->setChargeDetail($chargeDetail)
            ->setTaxCharges($taxCharges)
            ->setTotalTax($totalTax)
            ->setGrandTotalOfAllCharge($grandTotalOfAllCharge)
            ->setGrandTotalOfAllIncentedCharge($grandTotalOfAllIncentedCharge)
            ->setPreTaxTotalCharge($preTaxTotalCharge)
            ->setPreTaxTotalIncentedCharge($preTaxTotalIncentedCharge);
    }
    /**
     * Get Disclaimer value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDisclaimerType|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * Set Disclaimer value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDisclaimerType $disclaimer
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setDisclaimer(\Ups_pickup\upspickupStruct\Ups_pickupDisclaimerType $disclaimer = null)
    {
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Get RateType value
     * @return string|null
     */
    public function getRateType()
    {
        return $this->RateType;
    }
    /**
     * Set RateType value
     * @param string $rateType
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setRateType($rateType = null)
    {
        // validation for constraint: string
        if (!is_null($rateType) && !is_string($rateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateType, true), gettype($rateType)), __LINE__);
        }
        $this->RateType = $rateType;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ChargeDetail value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType[]|null
     */
    public function getChargeDetail()
    {
        return $this->ChargeDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setChargeDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChargeDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeDetailForArrayConstraintsFromSetChargeDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateResultTypeChargeDetailItem) {
            // validation for constraint: itemType
            if (!$rateResultTypeChargeDetailItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType) {
                $invalidValues[] = is_object($rateResultTypeChargeDetailItem) ? get_class($rateResultTypeChargeDetailItem) : sprintf('%s(%s)', gettype($rateResultTypeChargeDetailItem), var_export($rateResultTypeChargeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChargeDetail property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChargeDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType[] $chargeDetail
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setChargeDetail(array $chargeDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeDetailArrayErrorMessage = self::validateChargeDetailForArrayConstraintsFromSetChargeDetail($chargeDetail))) {
            throw new \InvalidArgumentException($chargeDetailArrayErrorMessage, __LINE__);
        }
        $this->ChargeDetail = $chargeDetail;
        return $this;
    }
    /**
     * Add item to ChargeDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function addToChargeDetail(\Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType) {
            throw new \InvalidArgumentException(sprintf('The ChargeDetail property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChargeDetail[] = $item;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateResultTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$rateResultTypeTaxChargesItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType) {
                $invalidValues[] = is_object($rateResultTypeTaxChargesItem) ? get_class($rateResultTypeTaxChargesItem) : sprintf('%s(%s)', gettype($rateResultTypeTaxChargesItem), var_export($rateResultTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType[] $taxCharges
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function addToTaxCharges(\Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupTaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalTax value
     * @return string|null
     */
    public function getTotalTax()
    {
        return $this->TotalTax;
    }
    /**
     * Set TotalTax value
     * @param string $totalTax
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setTotalTax($totalTax = null)
    {
        // validation for constraint: string
        if (!is_null($totalTax) && !is_string($totalTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalTax, true), gettype($totalTax)), __LINE__);
        }
        $this->TotalTax = $totalTax;
        return $this;
    }
    /**
     * Get GrandTotalOfAllCharge value
     * @return string|null
     */
    public function getGrandTotalOfAllCharge()
    {
        return $this->GrandTotalOfAllCharge;
    }
    /**
     * Set GrandTotalOfAllCharge value
     * @param string $grandTotalOfAllCharge
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setGrandTotalOfAllCharge($grandTotalOfAllCharge = null)
    {
        // validation for constraint: string
        if (!is_null($grandTotalOfAllCharge) && !is_string($grandTotalOfAllCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grandTotalOfAllCharge, true), gettype($grandTotalOfAllCharge)), __LINE__);
        }
        $this->GrandTotalOfAllCharge = $grandTotalOfAllCharge;
        return $this;
    }
    /**
     * Get GrandTotalOfAllIncentedCharge value
     * @return string|null
     */
    public function getGrandTotalOfAllIncentedCharge()
    {
        return $this->GrandTotalOfAllIncentedCharge;
    }
    /**
     * Set GrandTotalOfAllIncentedCharge value
     * @param string $grandTotalOfAllIncentedCharge
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setGrandTotalOfAllIncentedCharge($grandTotalOfAllIncentedCharge = null)
    {
        // validation for constraint: string
        if (!is_null($grandTotalOfAllIncentedCharge) && !is_string($grandTotalOfAllIncentedCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grandTotalOfAllIncentedCharge, true), gettype($grandTotalOfAllIncentedCharge)), __LINE__);
        }
        $this->GrandTotalOfAllIncentedCharge = $grandTotalOfAllIncentedCharge;
        return $this;
    }
    /**
     * Get PreTaxTotalCharge value
     * @return string|null
     */
    public function getPreTaxTotalCharge()
    {
        return $this->PreTaxTotalCharge;
    }
    /**
     * Set PreTaxTotalCharge value
     * @param string $preTaxTotalCharge
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setPreTaxTotalCharge($preTaxTotalCharge = null)
    {
        // validation for constraint: string
        if (!is_null($preTaxTotalCharge) && !is_string($preTaxTotalCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preTaxTotalCharge, true), gettype($preTaxTotalCharge)), __LINE__);
        }
        $this->PreTaxTotalCharge = $preTaxTotalCharge;
        return $this;
    }
    /**
     * Get PreTaxTotalIncentedCharge value
     * @return string|null
     */
    public function getPreTaxTotalIncentedCharge()
    {
        return $this->PreTaxTotalIncentedCharge;
    }
    /**
     * Set PreTaxTotalIncentedCharge value
     * @param string $preTaxTotalIncentedCharge
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRateResultType
     */
    public function setPreTaxTotalIncentedCharge($preTaxTotalIncentedCharge = null)
    {
        // validation for constraint: string
        if (!is_null($preTaxTotalIncentedCharge) && !is_string($preTaxTotalIncentedCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preTaxTotalIncentedCharge, true), gettype($preTaxTotalIncentedCharge)), __LINE__);
        }
        $this->PreTaxTotalIncentedCharge = $preTaxTotalIncentedCharge;
        return $this;
    }
}
