<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupAddressType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupAddressType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The ContactName
     * @var string
     */
    public $ContactName;
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $AddressLine;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Room;
    /**
     * The Floor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Floor;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The StateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StateProvince;
    /**
     * The Urbanization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Urbanization;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The ResidentialIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * @var string
     */
    public $ResidentialIndicator;
    /**
     * The PickupPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PickupPoint;
    /**
     * The Phone
     * @var \Ups_pickup\upspickupStruct\Ups_pickupPhoneType
     */
    public $Phone;
    /**
     * Constructor method for PickupAddressType
     * @uses Ups_pickupPickupAddressType::setCompanyName()
     * @uses Ups_pickupPickupAddressType::setContactName()
     * @uses Ups_pickupPickupAddressType::setAddressLine()
     * @uses Ups_pickupPickupAddressType::setRoom()
     * @uses Ups_pickupPickupAddressType::setFloor()
     * @uses Ups_pickupPickupAddressType::setCity()
     * @uses Ups_pickupPickupAddressType::setStateProvince()
     * @uses Ups_pickupPickupAddressType::setUrbanization()
     * @uses Ups_pickupPickupAddressType::setPostalCode()
     * @uses Ups_pickupPickupAddressType::setCountryCode()
     * @uses Ups_pickupPickupAddressType::setResidentialIndicator()
     * @uses Ups_pickupPickupAddressType::setPickupPoint()
     * @uses Ups_pickupPickupAddressType::setPhone()
     * @param string $companyName
     * @param string $contactName
     * @param string[] $addressLine
     * @param string $room
     * @param string $floor
     * @param string $city
     * @param string $stateProvince
     * @param string $urbanization
     * @param string $postalCode
     * @param string $countryCode
     * @param string $residentialIndicator
     * @param string $pickupPoint
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPhoneType $phone
     */
    public function __construct($companyName = null, $contactName = null, array $addressLine = array(), $room = null, $floor = null, $city = null, $stateProvince = null, $urbanization = null, $postalCode = null, $countryCode = null, $residentialIndicator = 'N', $pickupPoint = null, \Ups_pickup\upspickupStruct\Ups_pickupPhoneType $phone = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setContactName($contactName)
            ->setAddressLine($addressLine)
            ->setRoom($room)
            ->setFloor($floor)
            ->setCity($city)
            ->setStateProvince($stateProvince)
            ->setUrbanization($urbanization)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode)
            ->setResidentialIndicator($residentialIndicator)
            ->setPickupPoint($pickupPoint)
            ->setPhone($phone);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickupAddressTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($pickupAddressTypeAddressLineItem)) {
                $invalidValues[] = is_object($pickupAddressTypeAddressLineItem) ? get_class($pickupAddressTypeAddressLineItem) : sprintf('%s(%s)', gettype($pickupAddressTypeAddressLineItem), var_export($pickupAddressTypeAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get Room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param string $room
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Get Floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param string $floor
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvince value
     * @return string|null
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }
    /**
     * Set StateProvince value
     * @param string $stateProvince
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        $this->StateProvince = $stateProvince;
        return $this;
    }
    /**
     * Get Urbanization value
     * @return string|null
     */
    public function getUrbanization()
    {
        return $this->Urbanization;
    }
    /**
     * Set Urbanization value
     * @param string $urbanization
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setUrbanization($urbanization = null)
    {
        // validation for constraint: string
        if (!is_null($urbanization) && !is_string($urbanization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urbanization, true), gettype($urbanization)), __LINE__);
        }
        $this->Urbanization = $urbanization;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ResidentialIndicator value
     * @return string|null
     */
    public function getResidentialIndicator()
    {
        return $this->ResidentialIndicator;
    }
    /**
     * Set ResidentialIndicator value
     * @param string $residentialIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setResidentialIndicator($residentialIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($residentialIndicator) && !is_string($residentialIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialIndicator, true), gettype($residentialIndicator)), __LINE__);
        }
        $this->ResidentialIndicator = $residentialIndicator;
        return $this;
    }
    /**
     * Get PickupPoint value
     * @return string|null
     */
    public function getPickupPoint()
    {
        return $this->PickupPoint;
    }
    /**
     * Set PickupPoint value
     * @param string $pickupPoint
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setPickupPoint($pickupPoint = null)
    {
        // validation for constraint: string
        if (!is_null($pickupPoint) && !is_string($pickupPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupPoint, true), gettype($pickupPoint)), __LINE__);
        }
        $this->PickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get Phone value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPhoneType|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPhoneType $phone
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public function setPhone(\Ups_pickup\upspickupStruct\Ups_pickupPhoneType $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
}
