<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DropOffFacilitiesType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupDropOffFacilitiesType extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Address
     * @var \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public $Address;
    /**
     * The SLIC
     * @var string
     */
    public $SLIC;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Timezone
     * @var string
     */
    public $Timezone;
    /**
     * The Phone
     * @var string
     */
    public $Phone;
    /**
     * The Fax
     * @var string
     */
    public $Fax;
    /**
     * The FacilityTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupFacilityTimeType
     */
    public $FacilityTime;
    /**
     * The OriginOrDestination
     * @var string
     */
    public $OriginOrDestination;
    /**
     * The LocalizedInstruction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType[]
     */
    public $LocalizedInstruction;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupDistanceType
     */
    public $Distance;
    /**
     * Constructor method for DropOffFacilitiesType
     * @uses Ups_pickupDropOffFacilitiesType::setName()
     * @uses Ups_pickupDropOffFacilitiesType::setAddress()
     * @uses Ups_pickupDropOffFacilitiesType::setSLIC()
     * @uses Ups_pickupDropOffFacilitiesType::setType()
     * @uses Ups_pickupDropOffFacilitiesType::setTimezone()
     * @uses Ups_pickupDropOffFacilitiesType::setPhone()
     * @uses Ups_pickupDropOffFacilitiesType::setFax()
     * @uses Ups_pickupDropOffFacilitiesType::setFacilityTime()
     * @uses Ups_pickupDropOffFacilitiesType::setOriginOrDestination()
     * @uses Ups_pickupDropOffFacilitiesType::setLocalizedInstruction()
     * @uses Ups_pickupDropOffFacilitiesType::setDistance()
     * @param string $name
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAddressType $address
     * @param string $sLIC
     * @param string $type
     * @param string $timezone
     * @param string $phone
     * @param string $fax
     * @param \Ups_pickup\upspickupStruct\Ups_pickupFacilityTimeType $facilityTime
     * @param string $originOrDestination
     * @param \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType[] $localizedInstruction
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDistanceType $distance
     */
    public function __construct($name = null, \Ups_pickup\upspickupStruct\Ups_pickupAddressType $address = null, $sLIC = null, $type = null, $timezone = null, $phone = null, $fax = null, \Ups_pickup\upspickupStruct\Ups_pickupFacilityTimeType $facilityTime = null, $originOrDestination = null, array $localizedInstruction = array(), \Ups_pickup\upspickupStruct\Ups_pickupDistanceType $distance = null)
    {
        $this
            ->setName($name)
            ->setAddress($address)
            ->setSLIC($sLIC)
            ->setType($type)
            ->setTimezone($timezone)
            ->setPhone($phone)
            ->setFax($fax)
            ->setFacilityTime($facilityTime)
            ->setOriginOrDestination($originOrDestination)
            ->setLocalizedInstruction($localizedInstruction)
            ->setDistance($distance);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAddressType $address
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setAddress(\Ups_pickup\upspickupStruct\Ups_pickupAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get SLIC value
     * @return string|null
     */
    public function getSLIC()
    {
        return $this->SLIC;
    }
    /**
     * Set SLIC value
     * @param string $sLIC
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setSLIC($sLIC = null)
    {
        // validation for constraint: string
        if (!is_null($sLIC) && !is_string($sLIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLIC, true), gettype($sLIC)), __LINE__);
        }
        $this->SLIC = $sLIC;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Timezone value
     * @return string|null
     */
    public function getTimezone()
    {
        return $this->Timezone;
    }
    /**
     * Set Timezone value
     * @param string $timezone
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setTimezone($timezone = null)
    {
        // validation for constraint: string
        if (!is_null($timezone) && !is_string($timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timezone, true), gettype($timezone)), __LINE__);
        }
        $this->Timezone = $timezone;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get FacilityTime value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFacilityTimeType|null
     */
    public function getFacilityTime()
    {
        return $this->FacilityTime;
    }
    /**
     * Set FacilityTime value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupFacilityTimeType $facilityTime
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setFacilityTime(\Ups_pickup\upspickupStruct\Ups_pickupFacilityTimeType $facilityTime = null)
    {
        $this->FacilityTime = $facilityTime;
        return $this;
    }
    /**
     * Get OriginOrDestination value
     * @return string|null
     */
    public function getOriginOrDestination()
    {
        return $this->OriginOrDestination;
    }
    /**
     * Set OriginOrDestination value
     * @param string $originOrDestination
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setOriginOrDestination($originOrDestination = null)
    {
        // validation for constraint: string
        if (!is_null($originOrDestination) && !is_string($originOrDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originOrDestination, true), gettype($originOrDestination)), __LINE__);
        }
        $this->OriginOrDestination = $originOrDestination;
        return $this;
    }
    /**
     * Get LocalizedInstruction value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType[]|null
     */
    public function getLocalizedInstruction()
    {
        return $this->LocalizedInstruction;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalizedInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalizedInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalizedInstructionForArrayConstraintsFromSetLocalizedInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dropOffFacilitiesTypeLocalizedInstructionItem) {
            // validation for constraint: itemType
            if (!$dropOffFacilitiesTypeLocalizedInstructionItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType) {
                $invalidValues[] = is_object($dropOffFacilitiesTypeLocalizedInstructionItem) ? get_class($dropOffFacilitiesTypeLocalizedInstructionItem) : sprintf('%s(%s)', gettype($dropOffFacilitiesTypeLocalizedInstructionItem), var_export($dropOffFacilitiesTypeLocalizedInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocalizedInstruction property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocalizedInstruction value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType[] $localizedInstruction
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setLocalizedInstruction(array $localizedInstruction = array())
    {
        // validation for constraint: array
        if ('' !== ($localizedInstructionArrayErrorMessage = self::validateLocalizedInstructionForArrayConstraintsFromSetLocalizedInstruction($localizedInstruction))) {
            throw new \InvalidArgumentException($localizedInstructionArrayErrorMessage, __LINE__);
        }
        $this->LocalizedInstruction = $localizedInstruction;
        return $this;
    }
    /**
     * Add item to LocalizedInstruction value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function addToLocalizedInstruction(\Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType) {
            throw new \InvalidArgumentException(sprintf('The LocalizedInstruction property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupLocalizedInstructionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LocalizedInstruction[] = $item;
        return $this;
    }
    /**
     * Get Distance value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDistanceType|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDistanceType $distance
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDropOffFacilitiesType
     */
    public function setDistance(\Ups_pickup\upspickupStruct\Ups_pickupDistanceType $distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
}
