<?php

namespace Ups_pickup\upspickupService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process upspickupService
 * @package Ups_pickup
 * @subpackage Services
 */
class Ups_pickupProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessPickupCreation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest $body
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationResponse|bool
     */
    public function ProcessPickupCreation(\Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPickupCreation($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ProcessPickupGetServiceCenterFacilities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest $body
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesResponse|bool
     */
    public function ProcessPickupGetServiceCenterFacilities(\Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPickupGetServiceCenterFacilities($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPickupRate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest $body
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateResponse|bool
     */
    public function ProcessPickupRate(\Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPickupRate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPickupCancel
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelRequest $body
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelResponse|bool
     */
    public function ProcessPickupCancel(\Ups_pickup\upspickupStruct\Ups_pickupPickupCancelRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPickupCancel($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPickupPendingStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusRequest $body
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusResponse|bool
     */
    public function ProcessPickupPendingStatus(\Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPickupPendingStatus($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ProcessPickupGetPoliticalDivision1List
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_pickup\upspickupStruct\Ups_pickupUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupGetPoliticalDivision1ListRequest $body
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetPoliticalDivision1ListResponse|bool
     */
    public function ProcessPickupGetPoliticalDivision1List(\Ups_pickup\upspickupStruct\Ups_pickupPickupGetPoliticalDivision1ListRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPickupGetPoliticalDivision1List($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelResponse|\Ups_pickup\upspickupStruct\Ups_pickupPickupCreationResponse|\Ups_pickup\upspickupStruct\Ups_pickupPickupGetPoliticalDivision1ListResponse|\Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesResponse|\Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusResponse|\Ups_pickup\upspickupStruct\Ups_pickupPickupRateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
