<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupCreationRequest upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupCreationRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_pickup\upspickupStruct\Ups_pickupRequestType
     */
    public $Request;
    /**
     * The RatePickupIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * @var string
     */
    public $RatePickupIndicator;
    /**
     * The TaxInformationIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $TaxInformationIndicator;
    /**
     * The UserLevelDiscountIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $UserLevelDiscountIndicator;
    /**
     * The Shipper
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupShipperType
     */
    public $Shipper;
    /**
     * The PickupDateInfo
     * @var \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType
     */
    public $PickupDateInfo;
    /**
     * The PickupAddress
     * @var \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType
     */
    public $PickupAddress;
    /**
     * The AlternateAddressIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * @var string
     */
    public $AlternateAddressIndicator;
    /**
     * The PickupPiece
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType[]
     */
    public $PickupPiece;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupWeightType
     */
    public $TotalWeight;
    /**
     * The OverweightIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $OverweightIndicator;
    /**
     * The TrackingData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType[]
     */
    public $TrackingData;
    /**
     * The TrackingDataWithReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType
     */
    public $TrackingDataWithReferenceNumber;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - default: 00
     * @var string
     */
    public $PaymentMethod;
    /**
     * The SpecialInstruction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstruction;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The FreightOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType
     */
    public $FreightOptions;
    /**
     * The ServiceCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCategory;
    /**
     * The CashType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CashType;
    /**
     * The ShippingLabelsAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingLabelsAvailable;
    /**
     * Constructor method for PickupCreationRequest
     * @uses Ups_pickupPickupCreationRequest::setRequest()
     * @uses Ups_pickupPickupCreationRequest::setRatePickupIndicator()
     * @uses Ups_pickupPickupCreationRequest::setTaxInformationIndicator()
     * @uses Ups_pickupPickupCreationRequest::setUserLevelDiscountIndicator()
     * @uses Ups_pickupPickupCreationRequest::setShipper()
     * @uses Ups_pickupPickupCreationRequest::setPickupDateInfo()
     * @uses Ups_pickupPickupCreationRequest::setPickupAddress()
     * @uses Ups_pickupPickupCreationRequest::setAlternateAddressIndicator()
     * @uses Ups_pickupPickupCreationRequest::setPickupPiece()
     * @uses Ups_pickupPickupCreationRequest::setTotalWeight()
     * @uses Ups_pickupPickupCreationRequest::setOverweightIndicator()
     * @uses Ups_pickupPickupCreationRequest::setTrackingData()
     * @uses Ups_pickupPickupCreationRequest::setTrackingDataWithReferenceNumber()
     * @uses Ups_pickupPickupCreationRequest::setPaymentMethod()
     * @uses Ups_pickupPickupCreationRequest::setSpecialInstruction()
     * @uses Ups_pickupPickupCreationRequest::setReferenceNumber()
     * @uses Ups_pickupPickupCreationRequest::setFreightOptions()
     * @uses Ups_pickupPickupCreationRequest::setServiceCategory()
     * @uses Ups_pickupPickupCreationRequest::setCashType()
     * @uses Ups_pickupPickupCreationRequest::setShippingLabelsAvailable()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @param string $ratePickupIndicator
     * @param string $taxInformationIndicator
     * @param string $userLevelDiscountIndicator
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipperType $shipper
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType $pickupAddress
     * @param string $alternateAddressIndicator
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType[] $pickupPiece
     * @param \Ups_pickup\upspickupStruct\Ups_pickupWeightType $totalWeight
     * @param string $overweightIndicator
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType[] $trackingData
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType $trackingDataWithReferenceNumber
     * @param string $paymentMethod
     * @param string $specialInstruction
     * @param string $referenceNumber
     * @param \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType $freightOptions
     * @param string $serviceCategory
     * @param string $cashType
     * @param string $shippingLabelsAvailable
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null, $ratePickupIndicator = 'N', $taxInformationIndicator = 'N', $userLevelDiscountIndicator = 'N', \Ups_pickup\upspickupStruct\Ups_pickupShipperType $shipper = null, \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo = null, \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType $pickupAddress = null, $alternateAddressIndicator = 'N', array $pickupPiece = array(), \Ups_pickup\upspickupStruct\Ups_pickupWeightType $totalWeight = null, $overweightIndicator = 'N', array $trackingData = array(), \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType $trackingDataWithReferenceNumber = null, $paymentMethod = '00', $specialInstruction = null, $referenceNumber = null, \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType $freightOptions = null, $serviceCategory = null, $cashType = null, $shippingLabelsAvailable = null)
    {
        $this
            ->setRequest($request)
            ->setRatePickupIndicator($ratePickupIndicator)
            ->setTaxInformationIndicator($taxInformationIndicator)
            ->setUserLevelDiscountIndicator($userLevelDiscountIndicator)
            ->setShipper($shipper)
            ->setPickupDateInfo($pickupDateInfo)
            ->setPickupAddress($pickupAddress)
            ->setAlternateAddressIndicator($alternateAddressIndicator)
            ->setPickupPiece($pickupPiece)
            ->setTotalWeight($totalWeight)
            ->setOverweightIndicator($overweightIndicator)
            ->setTrackingData($trackingData)
            ->setTrackingDataWithReferenceNumber($trackingDataWithReferenceNumber)
            ->setPaymentMethod($paymentMethod)
            ->setSpecialInstruction($specialInstruction)
            ->setReferenceNumber($referenceNumber)
            ->setFreightOptions($freightOptions)
            ->setServiceCategory($serviceCategory)
            ->setCashType($cashType)
            ->setShippingLabelsAvailable($shippingLabelsAvailable);
    }
    /**
     * Get Request value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setRequest(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get RatePickupIndicator value
     * @return string|null
     */
    public function getRatePickupIndicator()
    {
        return $this->RatePickupIndicator;
    }
    /**
     * Set RatePickupIndicator value
     * @param string $ratePickupIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setRatePickupIndicator($ratePickupIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($ratePickupIndicator) && !is_string($ratePickupIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePickupIndicator, true), gettype($ratePickupIndicator)), __LINE__);
        }
        $this->RatePickupIndicator = $ratePickupIndicator;
        return $this;
    }
    /**
     * Get TaxInformationIndicator value
     * @return string|null
     */
    public function getTaxInformationIndicator()
    {
        return $this->TaxInformationIndicator;
    }
    /**
     * Set TaxInformationIndicator value
     * @param string $taxInformationIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setTaxInformationIndicator($taxInformationIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($taxInformationIndicator) && !is_string($taxInformationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxInformationIndicator, true), gettype($taxInformationIndicator)), __LINE__);
        }
        $this->TaxInformationIndicator = $taxInformationIndicator;
        return $this;
    }
    /**
     * Get UserLevelDiscountIndicator value
     * @return string|null
     */
    public function getUserLevelDiscountIndicator()
    {
        return $this->UserLevelDiscountIndicator;
    }
    /**
     * Set UserLevelDiscountIndicator value
     * @param string $userLevelDiscountIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setUserLevelDiscountIndicator($userLevelDiscountIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($userLevelDiscountIndicator) && !is_string($userLevelDiscountIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLevelDiscountIndicator, true), gettype($userLevelDiscountIndicator)), __LINE__);
        }
        $this->UserLevelDiscountIndicator = $userLevelDiscountIndicator;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipperType|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipperType $shipper
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setShipper(\Ups_pickup\upspickupStruct\Ups_pickupShipperType $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get PickupDateInfo value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType|null
     */
    public function getPickupDateInfo()
    {
        return $this->PickupDateInfo;
    }
    /**
     * Set PickupDateInfo value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setPickupDateInfo(\Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo = null)
    {
        $this->PickupDateInfo = $pickupDateInfo;
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType $pickupAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setPickupAddress(\Ups_pickup\upspickupStruct\Ups_pickupPickupAddressType $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get AlternateAddressIndicator value
     * @return string|null
     */
    public function getAlternateAddressIndicator()
    {
        return $this->AlternateAddressIndicator;
    }
    /**
     * Set AlternateAddressIndicator value
     * @param string $alternateAddressIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setAlternateAddressIndicator($alternateAddressIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($alternateAddressIndicator) && !is_string($alternateAddressIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateAddressIndicator, true), gettype($alternateAddressIndicator)), __LINE__);
        }
        $this->AlternateAddressIndicator = $alternateAddressIndicator;
        return $this;
    }
    /**
     * Get PickupPiece value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType[]|null
     */
    public function getPickupPiece()
    {
        return $this->PickupPiece;
    }
    /**
     * This method is responsible for validating the values passed to the setPickupPiece method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickupPiece method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickupPieceForArrayConstraintsFromSetPickupPiece(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickupCreationRequestPickupPieceItem) {
            // validation for constraint: itemType
            if (!$pickupCreationRequestPickupPieceItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType) {
                $invalidValues[] = is_object($pickupCreationRequestPickupPieceItem) ? get_class($pickupCreationRequestPickupPieceItem) : sprintf('%s(%s)', gettype($pickupCreationRequestPickupPieceItem), var_export($pickupCreationRequestPickupPieceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PickupPiece property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PickupPiece value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType[] $pickupPiece
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setPickupPiece(array $pickupPiece = array())
    {
        // validation for constraint: array
        if ('' !== ($pickupPieceArrayErrorMessage = self::validatePickupPieceForArrayConstraintsFromSetPickupPiece($pickupPiece))) {
            throw new \InvalidArgumentException($pickupPieceArrayErrorMessage, __LINE__);
        }
        $this->PickupPiece = $pickupPiece;
        return $this;
    }
    /**
     * Add item to PickupPiece value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function addToPickupPiece(\Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType) {
            throw new \InvalidArgumentException(sprintf('The PickupPiece property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PickupPiece[] = $item;
        return $this;
    }
    /**
     * Get TotalWeight value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupWeightType|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupWeightType $totalWeight
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setTotalWeight(\Ups_pickup\upspickupStruct\Ups_pickupWeightType $totalWeight = null)
    {
        $this->TotalWeight = $totalWeight;
        return $this;
    }
    /**
     * Get OverweightIndicator value
     * @return string|null
     */
    public function getOverweightIndicator()
    {
        return $this->OverweightIndicator;
    }
    /**
     * Set OverweightIndicator value
     * @param string $overweightIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setOverweightIndicator($overweightIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($overweightIndicator) && !is_string($overweightIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overweightIndicator, true), gettype($overweightIndicator)), __LINE__);
        }
        $this->OverweightIndicator = $overweightIndicator;
        return $this;
    }
    /**
     * Get TrackingData value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType[]|null
     */
    public function getTrackingData()
    {
        return $this->TrackingData;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackingData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackingData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackingDataForArrayConstraintsFromSetTrackingData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickupCreationRequestTrackingDataItem) {
            // validation for constraint: itemType
            if (!$pickupCreationRequestTrackingDataItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType) {
                $invalidValues[] = is_object($pickupCreationRequestTrackingDataItem) ? get_class($pickupCreationRequestTrackingDataItem) : sprintf('%s(%s)', gettype($pickupCreationRequestTrackingDataItem), var_export($pickupCreationRequestTrackingDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrackingData property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrackingData value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType[] $trackingData
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setTrackingData(array $trackingData = array())
    {
        // validation for constraint: array
        if ('' !== ($trackingDataArrayErrorMessage = self::validateTrackingDataForArrayConstraintsFromSetTrackingData($trackingData))) {
            throw new \InvalidArgumentException($trackingDataArrayErrorMessage, __LINE__);
        }
        $this->TrackingData = $trackingData;
        return $this;
    }
    /**
     * Add item to TrackingData value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function addToTrackingData(\Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType) {
            throw new \InvalidArgumentException(sprintf('The TrackingData property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrackingData[] = $item;
        return $this;
    }
    /**
     * Get TrackingDataWithReferenceNumber value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType|null
     */
    public function getTrackingDataWithReferenceNumber()
    {
        return $this->TrackingDataWithReferenceNumber;
    }
    /**
     * Set TrackingDataWithReferenceNumber value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType $trackingDataWithReferenceNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setTrackingDataWithReferenceNumber(\Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType $trackingDataWithReferenceNumber = null)
    {
        $this->TrackingDataWithReferenceNumber = $trackingDataWithReferenceNumber;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setPaymentMethod($paymentMethod = '00')
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get SpecialInstruction value
     * @return string|null
     */
    public function getSpecialInstruction()
    {
        return $this->SpecialInstruction;
    }
    /**
     * Set SpecialInstruction value
     * @param string $specialInstruction
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setSpecialInstruction($specialInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstruction) && !is_string($specialInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstruction, true), gettype($specialInstruction)), __LINE__);
        }
        $this->SpecialInstruction = $specialInstruction;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get FreightOptions value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType|null
     */
    public function getFreightOptions()
    {
        return $this->FreightOptions;
    }
    /**
     * Set FreightOptions value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType $freightOptions
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setFreightOptions(\Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType $freightOptions = null)
    {
        $this->FreightOptions = $freightOptions;
        return $this;
    }
    /**
     * Get ServiceCategory value
     * @return string|null
     */
    public function getServiceCategory()
    {
        return $this->ServiceCategory;
    }
    /**
     * Set ServiceCategory value
     * @param string $serviceCategory
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setServiceCategory($serviceCategory = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCategory) && !is_string($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCategory, true), gettype($serviceCategory)), __LINE__);
        }
        $this->ServiceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get CashType value
     * @return string|null
     */
    public function getCashType()
    {
        return $this->CashType;
    }
    /**
     * Set CashType value
     * @param string $cashType
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setCashType($cashType = null)
    {
        // validation for constraint: string
        if (!is_null($cashType) && !is_string($cashType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashType, true), gettype($cashType)), __LINE__);
        }
        $this->CashType = $cashType;
        return $this;
    }
    /**
     * Get ShippingLabelsAvailable value
     * @return string|null
     */
    public function getShippingLabelsAvailable()
    {
        return $this->ShippingLabelsAvailable;
    }
    /**
     * Set ShippingLabelsAvailable value
     * @param string $shippingLabelsAvailable
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCreationRequest
     */
    public function setShippingLabelsAvailable($shippingLabelsAvailable = null)
    {
        // validation for constraint: string
        if (!is_null($shippingLabelsAvailable) && !is_string($shippingLabelsAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingLabelsAvailable, true), gettype($shippingLabelsAvailable)), __LINE__);
        }
        $this->ShippingLabelsAvailable = $shippingLabelsAvailable;
        return $this;
    }
}
