<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightOptionsType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupFreightOptionsType extends AbstractStructBase
{
    /**
     * The ShipmentServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType
     */
    public $ShipmentServiceOptions;
    /**
     * The OriginServiceCenterCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginServiceCenterCode;
    /**
     * The OriginServiceCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginServiceCountryCode;
    /**
     * The DestinationAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType
     */
    public $DestinationAddress;
    /**
     * The ShipmentDetail
     * @var \Ups_pickup\upspickupStruct\Ups_pickupShipmentDetailType
     */
    public $ShipmentDetail;
    /**
     * Constructor method for FreightOptionsType
     * @uses Ups_pickupFreightOptionsType::setShipmentServiceOptions()
     * @uses Ups_pickupFreightOptionsType::setOriginServiceCenterCode()
     * @uses Ups_pickupFreightOptionsType::setOriginServiceCountryCode()
     * @uses Ups_pickupFreightOptionsType::setDestinationAddress()
     * @uses Ups_pickupFreightOptionsType::setShipmentDetail()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType $shipmentServiceOptions
     * @param string $originServiceCenterCode
     * @param string $originServiceCountryCode
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipmentDetailType $shipmentDetail
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType $shipmentServiceOptions = null, $originServiceCenterCode = null, $originServiceCountryCode = null, \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress = null, \Ups_pickup\upspickupStruct\Ups_pickupShipmentDetailType $shipmentDetail = null)
    {
        $this
            ->setShipmentServiceOptions($shipmentServiceOptions)
            ->setOriginServiceCenterCode($originServiceCenterCode)
            ->setOriginServiceCountryCode($originServiceCountryCode)
            ->setDestinationAddress($destinationAddress)
            ->setShipmentDetail($shipmentDetail);
    }
    /**
     * Get ShipmentServiceOptions value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType|null
     */
    public function getShipmentServiceOptions()
    {
        return $this->ShipmentServiceOptions;
    }
    /**
     * Set ShipmentServiceOptions value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType $shipmentServiceOptions
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType
     */
    public function setShipmentServiceOptions(\Ups_pickup\upspickupStruct\Ups_pickupShipmentServiceOptionsType $shipmentServiceOptions = null)
    {
        $this->ShipmentServiceOptions = $shipmentServiceOptions;
        return $this;
    }
    /**
     * Get OriginServiceCenterCode value
     * @return string|null
     */
    public function getOriginServiceCenterCode()
    {
        return $this->OriginServiceCenterCode;
    }
    /**
     * Set OriginServiceCenterCode value
     * @param string $originServiceCenterCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType
     */
    public function setOriginServiceCenterCode($originServiceCenterCode = null)
    {
        // validation for constraint: string
        if (!is_null($originServiceCenterCode) && !is_string($originServiceCenterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originServiceCenterCode, true), gettype($originServiceCenterCode)), __LINE__);
        }
        $this->OriginServiceCenterCode = $originServiceCenterCode;
        return $this;
    }
    /**
     * Get OriginServiceCountryCode value
     * @return string|null
     */
    public function getOriginServiceCountryCode()
    {
        return $this->OriginServiceCountryCode;
    }
    /**
     * Set OriginServiceCountryCode value
     * @param string $originServiceCountryCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType
     */
    public function setOriginServiceCountryCode($originServiceCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($originServiceCountryCode) && !is_string($originServiceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originServiceCountryCode, true), gettype($originServiceCountryCode)), __LINE__);
        }
        $this->OriginServiceCountryCode = $originServiceCountryCode;
        return $this;
    }
    /**
     * Get DestinationAddress value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType|null
     */
    public function getDestinationAddress()
    {
        return $this->DestinationAddress;
    }
    /**
     * Set DestinationAddress value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType
     */
    public function setDestinationAddress(\Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress = null)
    {
        $this->DestinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get ShipmentDetail value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipmentDetailType|null
     */
    public function getShipmentDetail()
    {
        return $this->ShipmentDetail;
    }
    /**
     * Set ShipmentDetail value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipmentDetailType $shipmentDetail
     * @return \Ups_pickup\upspickupStruct\Ups_pickupFreightOptionsType
     */
    public function setShipmentDetail(\Ups_pickup\upspickupStruct\Ups_pickupShipmentDetailType $shipmentDetail = null)
    {
        $this->ShipmentDetail = $shipmentDetail;
        return $this;
    }
}
