<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \Ups_pickup\upspickupStruct\Ups_pickupCodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupLocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupCodeType[]
     */
    public $SubErrorCode;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType[]
     */
    public $AdditionalInformation;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for ErrorDetailType
     * @uses Ups_pickupErrorDetailType::setSeverity()
     * @uses Ups_pickupErrorDetailType::setPrimaryErrorCode()
     * @uses Ups_pickupErrorDetailType::setMinimumRetrySeconds()
     * @uses Ups_pickupErrorDetailType::setLocation()
     * @uses Ups_pickupErrorDetailType::setSubErrorCode()
     * @uses Ups_pickupErrorDetailType::setAdditionalInformation()
     * @uses Ups_pickupErrorDetailType::setElementLevelInformation()
     * @param string $severity
     * @param \Ups_pickup\upspickupStruct\Ups_pickupCodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \Ups_pickup\upspickupStruct\Ups_pickupLocationType $location
     * @param \Ups_pickup\upspickupStruct\Ups_pickupCodeType[] $subErrorCode
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType[] $additionalInformation
     * @param \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType $elementLevelInformation
     */
    public function __construct($severity = null, \Ups_pickup\upspickupStruct\Ups_pickupCodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \Ups_pickup\upspickupStruct\Ups_pickupLocationType $location = null, array $subErrorCode = array(), array $additionalInformation = array(), \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode)
            ->setAdditionalInformation($additionalInformation)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupCodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupCodeType $primaryErrorCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setPrimaryErrorCode(\Ups_pickup\upspickupStruct\Ups_pickupCodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupLocationType $location
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setLocation(\Ups_pickup\upspickupStruct\Ups_pickupLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupCodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupCodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupCodeType[] $subErrorCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupCodeType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function addToSubErrorCode(\Ups_pickup\upspickupStruct\Ups_pickupCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupCodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeAdditionalInformationItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType) {
                $invalidValues[] = is_object($errorDetailTypeAdditionalInformationItem) ? get_class($errorDetailTypeAdditionalInformationItem) : sprintf('%s(%s)', gettype($errorDetailTypeAdditionalInformationItem), var_export($errorDetailTypeAdditionalInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformation property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType[] $additionalInformation
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationArrayErrorMessage = self::validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation($additionalInformation))) {
            throw new \InvalidArgumentException($additionalInformationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function addToAdditionalInformation(\Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupAdditionalInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType $elementLevelInformation
     * @return \Ups_pickup\upspickupStruct\Ups_pickupErrorDetailType
     */
    public function setElementLevelInformation(\Ups_pickup\upspickupStruct\Ups_pickupElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
