<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingDataWithReferenceNumberType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupTrackingDataWithReferenceNumberType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $ReferenceNumber;
    /**
     * Constructor method for TrackingDataWithReferenceNumberType
     * @uses Ups_pickupTrackingDataWithReferenceNumberType::setTrackingNumber()
     * @uses Ups_pickupTrackingDataWithReferenceNumberType::setReferenceNumber()
     * @param string $trackingNumber
     * @param string[] $referenceNumber
     */
    public function __construct($trackingNumber = null, array $referenceNumber = array())
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDataWithReferenceNumberTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!is_string($trackingDataWithReferenceNumberTypeReferenceNumberItem)) {
                $invalidValues[] = is_object($trackingDataWithReferenceNumberTypeReferenceNumberItem) ? get_class($trackingDataWithReferenceNumberTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($trackingDataWithReferenceNumberTypeReferenceNumberItem), var_export($trackingDataWithReferenceNumberTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param string[] $referenceNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($referenceNumber) && count($referenceNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTrackingDataWithReferenceNumberType
     */
    public function addToReferenceNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->ReferenceNumber) && count($this->ReferenceNumber) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->ReferenceNumber)), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
}
