<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxInformationType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupTaxInformationType extends AbstractStructBase
{
    /**
     * The VatTaxID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VatTaxID;
    /**
     * The TaxIDType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxIDType;
    /**
     * The CertifiedElectronicMail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CertifiedElectronicMail;
    /**
     * The InterchangeSystemCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InterchangeSystemCode;
    /**
     * Constructor method for TaxInformationType
     * @uses Ups_pickupTaxInformationType::setVatTaxID()
     * @uses Ups_pickupTaxInformationType::setTaxIDType()
     * @uses Ups_pickupTaxInformationType::setCertifiedElectronicMail()
     * @uses Ups_pickupTaxInformationType::setInterchangeSystemCode()
     * @param string $vatTaxID
     * @param string $taxIDType
     * @param string $certifiedElectronicMail
     * @param string $interchangeSystemCode
     */
    public function __construct($vatTaxID = null, $taxIDType = null, $certifiedElectronicMail = null, $interchangeSystemCode = null)
    {
        $this
            ->setVatTaxID($vatTaxID)
            ->setTaxIDType($taxIDType)
            ->setCertifiedElectronicMail($certifiedElectronicMail)
            ->setInterchangeSystemCode($interchangeSystemCode);
    }
    /**
     * Get VatTaxID value
     * @return string|null
     */
    public function getVatTaxID()
    {
        return $this->VatTaxID;
    }
    /**
     * Set VatTaxID value
     * @param string $vatTaxID
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTaxInformationType
     */
    public function setVatTaxID($vatTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($vatTaxID) && !is_string($vatTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatTaxID, true), gettype($vatTaxID)), __LINE__);
        }
        $this->VatTaxID = $vatTaxID;
        return $this;
    }
    /**
     * Get TaxIDType value
     * @return string|null
     */
    public function getTaxIDType()
    {
        return $this->TaxIDType;
    }
    /**
     * Set TaxIDType value
     * @param string $taxIDType
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTaxInformationType
     */
    public function setTaxIDType($taxIDType = null)
    {
        // validation for constraint: string
        if (!is_null($taxIDType) && !is_string($taxIDType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIDType, true), gettype($taxIDType)), __LINE__);
        }
        $this->TaxIDType = $taxIDType;
        return $this;
    }
    /**
     * Get CertifiedElectronicMail value
     * @return string|null
     */
    public function getCertifiedElectronicMail()
    {
        return $this->CertifiedElectronicMail;
    }
    /**
     * Set CertifiedElectronicMail value
     * @param string $certifiedElectronicMail
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTaxInformationType
     */
    public function setCertifiedElectronicMail($certifiedElectronicMail = null)
    {
        // validation for constraint: string
        if (!is_null($certifiedElectronicMail) && !is_string($certifiedElectronicMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certifiedElectronicMail, true), gettype($certifiedElectronicMail)), __LINE__);
        }
        $this->CertifiedElectronicMail = $certifiedElectronicMail;
        return $this;
    }
    /**
     * Get InterchangeSystemCode value
     * @return string|null
     */
    public function getInterchangeSystemCode()
    {
        return $this->InterchangeSystemCode;
    }
    /**
     * Set InterchangeSystemCode value
     * @param string $interchangeSystemCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupTaxInformationType
     */
    public function setInterchangeSystemCode($interchangeSystemCode = null)
    {
        // validation for constraint: string
        if (!is_null($interchangeSystemCode) && !is_string($interchangeSystemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interchangeSystemCode, true), gettype($interchangeSystemCode)), __LINE__);
        }
        $this->InterchangeSystemCode = $interchangeSystemCode;
        return $this;
    }
}
