<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupRateRequest upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupRateRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_pickup\upspickupStruct\Ups_pickupRequestType
     */
    public $Request;
    /**
     * The ShipperAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupShipperAccountType
     */
    public $ShipperAccount;
    /**
     * The PickupAddress
     * @var \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public $PickupAddress;
    /**
     * The AlternateAddressIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * @var string
     */
    public $AlternateAddressIndicator;
    /**
     * The ServiceDateOption
     * @var string
     */
    public $ServiceDateOption;
    /**
     * The PickupDateInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType
     */
    public $PickupDateInfo;
    /**
     * The TaxInformationIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $TaxInformationIndicator;
    /**
     * The UserLevelDiscountIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $UserLevelDiscountIndicator;
    /**
     * Constructor method for PickupRateRequest
     * @uses Ups_pickupPickupRateRequest::setRequest()
     * @uses Ups_pickupPickupRateRequest::setShipperAccount()
     * @uses Ups_pickupPickupRateRequest::setPickupAddress()
     * @uses Ups_pickupPickupRateRequest::setAlternateAddressIndicator()
     * @uses Ups_pickupPickupRateRequest::setServiceDateOption()
     * @uses Ups_pickupPickupRateRequest::setPickupDateInfo()
     * @uses Ups_pickupPickupRateRequest::setTaxInformationIndicator()
     * @uses Ups_pickupPickupRateRequest::setUserLevelDiscountIndicator()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipperAccountType $shipperAccount
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAddressType $pickupAddress
     * @param string $alternateAddressIndicator
     * @param string $serviceDateOption
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo
     * @param string $taxInformationIndicator
     * @param string $userLevelDiscountIndicator
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null, \Ups_pickup\upspickupStruct\Ups_pickupShipperAccountType $shipperAccount = null, \Ups_pickup\upspickupStruct\Ups_pickupAddressType $pickupAddress = null, $alternateAddressIndicator = 'N', $serviceDateOption = null, \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo = null, $taxInformationIndicator = 'N', $userLevelDiscountIndicator = 'N')
    {
        $this
            ->setRequest($request)
            ->setShipperAccount($shipperAccount)
            ->setPickupAddress($pickupAddress)
            ->setAlternateAddressIndicator($alternateAddressIndicator)
            ->setServiceDateOption($serviceDateOption)
            ->setPickupDateInfo($pickupDateInfo)
            ->setTaxInformationIndicator($taxInformationIndicator)
            ->setUserLevelDiscountIndicator($userLevelDiscountIndicator);
    }
    /**
     * Get Request value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setRequest(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ShipperAccount value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupShipperAccountType|null
     */
    public function getShipperAccount()
    {
        return $this->ShipperAccount;
    }
    /**
     * Set ShipperAccount value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupShipperAccountType $shipperAccount
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setShipperAccount(\Ups_pickup\upspickupStruct\Ups_pickupShipperAccountType $shipperAccount = null)
    {
        $this->ShipperAccount = $shipperAccount;
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupAddressType $pickupAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setPickupAddress(\Ups_pickup\upspickupStruct\Ups_pickupAddressType $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get AlternateAddressIndicator value
     * @return string|null
     */
    public function getAlternateAddressIndicator()
    {
        return $this->AlternateAddressIndicator;
    }
    /**
     * Set AlternateAddressIndicator value
     * @param string $alternateAddressIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setAlternateAddressIndicator($alternateAddressIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($alternateAddressIndicator) && !is_string($alternateAddressIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateAddressIndicator, true), gettype($alternateAddressIndicator)), __LINE__);
        }
        $this->AlternateAddressIndicator = $alternateAddressIndicator;
        return $this;
    }
    /**
     * Get ServiceDateOption value
     * @return string|null
     */
    public function getServiceDateOption()
    {
        return $this->ServiceDateOption;
    }
    /**
     * Set ServiceDateOption value
     * @param string $serviceDateOption
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setServiceDateOption($serviceDateOption = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDateOption) && !is_string($serviceDateOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDateOption, true), gettype($serviceDateOption)), __LINE__);
        }
        $this->ServiceDateOption = $serviceDateOption;
        return $this;
    }
    /**
     * Get PickupDateInfo value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType|null
     */
    public function getPickupDateInfo()
    {
        return $this->PickupDateInfo;
    }
    /**
     * Set PickupDateInfo value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setPickupDateInfo(\Ups_pickup\upspickupStruct\Ups_pickupPickupDateInfoType $pickupDateInfo = null)
    {
        $this->PickupDateInfo = $pickupDateInfo;
        return $this;
    }
    /**
     * Get TaxInformationIndicator value
     * @return string|null
     */
    public function getTaxInformationIndicator()
    {
        return $this->TaxInformationIndicator;
    }
    /**
     * Set TaxInformationIndicator value
     * @param string $taxInformationIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setTaxInformationIndicator($taxInformationIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($taxInformationIndicator) && !is_string($taxInformationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxInformationIndicator, true), gettype($taxInformationIndicator)), __LINE__);
        }
        $this->TaxInformationIndicator = $taxInformationIndicator;
        return $this;
    }
    /**
     * Get UserLevelDiscountIndicator value
     * @return string|null
     */
    public function getUserLevelDiscountIndicator()
    {
        return $this->UserLevelDiscountIndicator;
    }
    /**
     * Set UserLevelDiscountIndicator value
     * @param string $userLevelDiscountIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupRateRequest
     */
    public function setUserLevelDiscountIndicator($userLevelDiscountIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($userLevelDiscountIndicator) && !is_string($userLevelDiscountIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLevelDiscountIndicator, true), gettype($userLevelDiscountIndicator)), __LINE__);
        }
        $this->UserLevelDiscountIndicator = $userLevelDiscountIndicator;
        return $this;
    }
}
