<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeDetailType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupChargeDetailType extends AbstractStructBase
{
    /**
     * The ChargeCode
     * @var string
     */
    public $ChargeCode;
    /**
     * The ChargeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChargeDescription;
    /**
     * The ChargeAmount
     * @var string
     */
    public $ChargeAmount;
    /**
     * The IncentedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncentedAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxAmount;
    /**
     * Constructor method for ChargeDetailType
     * @uses Ups_pickupChargeDetailType::setChargeCode()
     * @uses Ups_pickupChargeDetailType::setChargeDescription()
     * @uses Ups_pickupChargeDetailType::setChargeAmount()
     * @uses Ups_pickupChargeDetailType::setIncentedAmount()
     * @uses Ups_pickupChargeDetailType::setTaxAmount()
     * @param string $chargeCode
     * @param string $chargeDescription
     * @param string $chargeAmount
     * @param string $incentedAmount
     * @param string $taxAmount
     */
    public function __construct($chargeCode = null, $chargeDescription = null, $chargeAmount = null, $incentedAmount = null, $taxAmount = null)
    {
        $this
            ->setChargeCode($chargeCode)
            ->setChargeDescription($chargeDescription)
            ->setChargeAmount($chargeAmount)
            ->setIncentedAmount($incentedAmount)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCode, true), gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get ChargeDescription value
     * @return string|null
     */
    public function getChargeDescription()
    {
        return $this->ChargeDescription;
    }
    /**
     * Set ChargeDescription value
     * @param string $chargeDescription
     * @return \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType
     */
    public function setChargeDescription($chargeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDescription) && !is_string($chargeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeDescription, true), gettype($chargeDescription)), __LINE__);
        }
        $this->ChargeDescription = $chargeDescription;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return string|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param string $chargeAmount
     * @return \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType
     */
    public function setChargeAmount($chargeAmount = null)
    {
        // validation for constraint: string
        if (!is_null($chargeAmount) && !is_string($chargeAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeAmount, true), gettype($chargeAmount)), __LINE__);
        }
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get IncentedAmount value
     * @return string|null
     */
    public function getIncentedAmount()
    {
        return $this->IncentedAmount;
    }
    /**
     * Set IncentedAmount value
     * @param string $incentedAmount
     * @return \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType
     */
    public function setIncentedAmount($incentedAmount = null)
    {
        // validation for constraint: string
        if (!is_null($incentedAmount) && !is_string($incentedAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incentedAmount, true), gettype($incentedAmount)), __LINE__);
        }
        $this->IncentedAmount = $incentedAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return string|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param string $taxAmount
     * @return \Ups_pickup\upspickupStruct\Ups_pickupChargeDetailType
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: string
        if (!is_null($taxAmount) && !is_string($taxAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
}
