<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StreetAddressArtifactType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupStreetAddressArtifactType extends AbstractStructBase
{
    /**
     * The StreetNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetNumber;
    /**
     * The StreetPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetPrefix;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetName;
    /**
     * The StreetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetType;
    /**
     * The StreetSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetSuffix;
    /**
     * The UnparsedStreetAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UnparsedStreetAddress;
    /**
     * The StreetAddressArtifactSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetAddressArtifactSource;
    /**
     * The StreetAddressMatchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetAddressMatchCode;
    /**
     * Constructor method for StreetAddressArtifactType
     * @uses Ups_pickupStreetAddressArtifactType::setStreetNumber()
     * @uses Ups_pickupStreetAddressArtifactType::setStreetPrefix()
     * @uses Ups_pickupStreetAddressArtifactType::setStreetName()
     * @uses Ups_pickupStreetAddressArtifactType::setStreetType()
     * @uses Ups_pickupStreetAddressArtifactType::setStreetSuffix()
     * @uses Ups_pickupStreetAddressArtifactType::setUnparsedStreetAddress()
     * @uses Ups_pickupStreetAddressArtifactType::setStreetAddressArtifactSource()
     * @uses Ups_pickupStreetAddressArtifactType::setStreetAddressMatchCode()
     * @param string $streetNumber
     * @param string $streetPrefix
     * @param string $streetName
     * @param string $streetType
     * @param string $streetSuffix
     * @param string $unparsedStreetAddress
     * @param string $streetAddressArtifactSource
     * @param string $streetAddressMatchCode
     */
    public function __construct($streetNumber = null, $streetPrefix = null, $streetName = null, $streetType = null, $streetSuffix = null, $unparsedStreetAddress = null, $streetAddressArtifactSource = null, $streetAddressMatchCode = null)
    {
        $this
            ->setStreetNumber($streetNumber)
            ->setStreetPrefix($streetPrefix)
            ->setStreetName($streetName)
            ->setStreetType($streetType)
            ->setStreetSuffix($streetSuffix)
            ->setUnparsedStreetAddress($unparsedStreetAddress)
            ->setStreetAddressArtifactSource($streetAddressArtifactSource)
            ->setStreetAddressMatchCode($streetAddressMatchCode);
    }
    /**
     * Get StreetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get StreetPrefix value
     * @return string|null
     */
    public function getStreetPrefix()
    {
        return $this->StreetPrefix;
    }
    /**
     * Set StreetPrefix value
     * @param string $streetPrefix
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetPrefix($streetPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($streetPrefix) && !is_string($streetPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetPrefix, true), gettype($streetPrefix)), __LINE__);
        }
        $this->StreetPrefix = $streetPrefix;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetType value
     * @return string|null
     */
    public function getStreetType()
    {
        return $this->StreetType;
    }
    /**
     * Set StreetType value
     * @param string $streetType
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetType($streetType = null)
    {
        // validation for constraint: string
        if (!is_null($streetType) && !is_string($streetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetType, true), gettype($streetType)), __LINE__);
        }
        $this->StreetType = $streetType;
        return $this;
    }
    /**
     * Get StreetSuffix value
     * @return string|null
     */
    public function getStreetSuffix()
    {
        return $this->StreetSuffix;
    }
    /**
     * Set StreetSuffix value
     * @param string $streetSuffix
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetSuffix($streetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($streetSuffix) && !is_string($streetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetSuffix, true), gettype($streetSuffix)), __LINE__);
        }
        $this->StreetSuffix = $streetSuffix;
        return $this;
    }
    /**
     * Get UnparsedStreetAddress value
     * @return string|null
     */
    public function getUnparsedStreetAddress()
    {
        return $this->UnparsedStreetAddress;
    }
    /**
     * Set UnparsedStreetAddress value
     * @param string $unparsedStreetAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setUnparsedStreetAddress($unparsedStreetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($unparsedStreetAddress) && !is_string($unparsedStreetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unparsedStreetAddress, true), gettype($unparsedStreetAddress)), __LINE__);
        }
        $this->UnparsedStreetAddress = $unparsedStreetAddress;
        return $this;
    }
    /**
     * Get StreetAddressArtifactSource value
     * @return string|null
     */
    public function getStreetAddressArtifactSource()
    {
        return $this->StreetAddressArtifactSource;
    }
    /**
     * Set StreetAddressArtifactSource value
     * @param string $streetAddressArtifactSource
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetAddressArtifactSource($streetAddressArtifactSource = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddressArtifactSource) && !is_string($streetAddressArtifactSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddressArtifactSource, true), gettype($streetAddressArtifactSource)), __LINE__);
        }
        $this->StreetAddressArtifactSource = $streetAddressArtifactSource;
        return $this;
    }
    /**
     * Get StreetAddressMatchCode value
     * @return string|null
     */
    public function getStreetAddressMatchCode()
    {
        return $this->StreetAddressMatchCode;
    }
    /**
     * Set StreetAddressMatchCode value
     * @param string $streetAddressMatchCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupStreetAddressArtifactType
     */
    public function setStreetAddressMatchCode($streetAddressMatchCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddressMatchCode) && !is_string($streetAddressMatchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddressMatchCode, true), gettype($streetAddressMatchCode)), __LINE__);
        }
        $this->StreetAddressMatchCode = $streetAddressMatchCode;
        return $this;
    }
}
