<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupPieceServiceType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupPieceServiceType extends AbstractStructBase
{
    /**
     * The ServiceCode
     * @var string
     */
    public $ServiceCode;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * The DestinationCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCountryCode;
    /**
     * The ContainerCode
     * @var string
     */
    public $ContainerCode;
    /**
     * Constructor method for PickupPieceServiceType
     * @uses Ups_pickupPickupPieceServiceType::setServiceCode()
     * @uses Ups_pickupPickupPieceServiceType::setQuantity()
     * @uses Ups_pickupPickupPieceServiceType::setDestinationCountryCode()
     * @uses Ups_pickupPickupPieceServiceType::setContainerCode()
     * @param string $serviceCode
     * @param string $quantity
     * @param string $destinationCountryCode
     * @param string $containerCode
     */
    public function __construct($serviceCode = null, $quantity = null, $destinationCountryCode = null, $containerCode = null)
    {
        $this
            ->setServiceCode($serviceCode)
            ->setQuantity($quantity)
            ->setDestinationCountryCode($destinationCountryCode)
            ->setContainerCode($containerCode);
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get DestinationCountryCode value
     * @return string|null
     */
    public function getDestinationCountryCode()
    {
        return $this->DestinationCountryCode;
    }
    /**
     * Set DestinationCountryCode value
     * @param string $destinationCountryCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType
     */
    public function setDestinationCountryCode($destinationCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountryCode) && !is_string($destinationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCountryCode, true), gettype($destinationCountryCode)), __LINE__);
        }
        $this->DestinationCountryCode = $destinationCountryCode;
        return $this;
    }
    /**
     * Get ContainerCode value
     * @return string|null
     */
    public function getContainerCode()
    {
        return $this->ContainerCode;
    }
    /**
     * Set ContainerCode value
     * @param string $containerCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType
     */
    public function setContainerCode($containerCode = null)
    {
        // validation for constraint: string
        if (!is_null($containerCode) && !is_string($containerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerCode, true), gettype($containerCode)), __LINE__);
        }
        $this->ContainerCode = $containerCode;
        return $this;
    }
}
