<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupPendingStatusRequest upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupPendingStatusRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_pickup\upspickupStruct\Ups_pickupRequestType
     */
    public $Request;
    /**
     * The PickupType
     * @var string
     */
    public $PickupType;
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for PickupPendingStatusRequest
     * @uses Ups_pickupPickupPendingStatusRequest::setRequest()
     * @uses Ups_pickupPickupPendingStatusRequest::setPickupType()
     * @uses Ups_pickupPickupPendingStatusRequest::setAccountNumber()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @param string $pickupType
     * @param string $accountNumber
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null, $pickupType = null, $accountNumber = null)
    {
        $this
            ->setRequest($request)
            ->setPickupType($pickupType)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get Request value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusRequest
     */
    public function setRequest(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get PickupType value
     * @return string|null
     */
    public function getPickupType()
    {
        return $this->PickupType;
    }
    /**
     * Set PickupType value
     * @param string $pickupType
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusRequest
     */
    public function setPickupType($pickupType = null)
    {
        // validation for constraint: string
        if (!is_null($pickupType) && !is_string($pickupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupType, true), gettype($pickupType)), __LINE__);
        }
        $this->PickupType = $pickupType;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPendingStatusRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
}
