<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupGetServiceCenterFacilitiesRequest upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupGetServiceCenterFacilitiesRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_pickup\upspickupStruct\Ups_pickupRequestType
     */
    public $Request;
    /**
     * The PickupPiece
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType[]
     */
    public $PickupPiece;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType
     */
    public $OriginAddress;
    /**
     * The DestinationAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType
     */
    public $DestinationAddress;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Locale;
    /**
     * The ProximitySearchIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProximitySearchIndicator;
    /**
     * Constructor method for PickupGetServiceCenterFacilitiesRequest
     * @uses Ups_pickupPickupGetServiceCenterFacilitiesRequest::setRequest()
     * @uses Ups_pickupPickupGetServiceCenterFacilitiesRequest::setPickupPiece()
     * @uses Ups_pickupPickupGetServiceCenterFacilitiesRequest::setOriginAddress()
     * @uses Ups_pickupPickupGetServiceCenterFacilitiesRequest::setDestinationAddress()
     * @uses Ups_pickupPickupGetServiceCenterFacilitiesRequest::setLocale()
     * @uses Ups_pickupPickupGetServiceCenterFacilitiesRequest::setProximitySearchIndicator()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType[] $pickupPiece
     * @param \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType $originAddress
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress
     * @param string $locale
     * @param string $proximitySearchIndicator
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null, array $pickupPiece = array(), \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType $originAddress = null, \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress = null, $locale = null, $proximitySearchIndicator = null)
    {
        $this
            ->setRequest($request)
            ->setPickupPiece($pickupPiece)
            ->setOriginAddress($originAddress)
            ->setDestinationAddress($destinationAddress)
            ->setLocale($locale)
            ->setProximitySearchIndicator($proximitySearchIndicator);
    }
    /**
     * Get Request value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function setRequest(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get PickupPiece value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType[]|null
     */
    public function getPickupPiece()
    {
        return $this->PickupPiece;
    }
    /**
     * This method is responsible for validating the values passed to the setPickupPiece method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickupPiece method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickupPieceForArrayConstraintsFromSetPickupPiece(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickupGetServiceCenterFacilitiesRequestPickupPieceItem) {
            // validation for constraint: itemType
            if (!$pickupGetServiceCenterFacilitiesRequestPickupPieceItem instanceof \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType) {
                $invalidValues[] = is_object($pickupGetServiceCenterFacilitiesRequestPickupPieceItem) ? get_class($pickupGetServiceCenterFacilitiesRequestPickupPieceItem) : sprintf('%s(%s)', gettype($pickupGetServiceCenterFacilitiesRequestPickupPieceItem), var_export($pickupGetServiceCenterFacilitiesRequestPickupPieceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PickupPiece property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PickupPiece value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType[] $pickupPiece
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function setPickupPiece(array $pickupPiece = array())
    {
        // validation for constraint: array
        if ('' !== ($pickupPieceArrayErrorMessage = self::validatePickupPieceForArrayConstraintsFromSetPickupPiece($pickupPiece))) {
            throw new \InvalidArgumentException($pickupPieceArrayErrorMessage, __LINE__);
        }
        $this->PickupPiece = $pickupPiece;
        return $this;
    }
    /**
     * Add item to PickupPiece value
     * @throws \InvalidArgumentException
     * @param \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function addToPickupPiece(\Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType) {
            throw new \InvalidArgumentException(sprintf('The PickupPiece property can only contain items of type \Ups_pickup\upspickupStruct\Ups_pickupPickupPieceServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PickupPiece[] = $item;
        return $this;
    }
    /**
     * Get OriginAddress value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }
    /**
     * Set OriginAddress value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType $originAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function setOriginAddress(\Ups_pickup\upspickupStruct\Ups_pickupOriginAddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }
    /**
     * Get DestinationAddress value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType|null
     */
    public function getDestinationAddress()
    {
        return $this->DestinationAddress;
    }
    /**
     * Set DestinationAddress value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function setDestinationAddress(\Ups_pickup\upspickupStruct\Ups_pickupDestinationAddressType $destinationAddress = null)
    {
        $this->DestinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Get ProximitySearchIndicator value
     * @return string|null
     */
    public function getProximitySearchIndicator()
    {
        return $this->ProximitySearchIndicator;
    }
    /**
     * Set ProximitySearchIndicator value
     * @param string $proximitySearchIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupGetServiceCenterFacilitiesRequest
     */
    public function setProximitySearchIndicator($proximitySearchIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($proximitySearchIndicator) && !is_string($proximitySearchIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximitySearchIndicator, true), gettype($proximitySearchIndicator)), __LINE__);
        }
        $this->ProximitySearchIndicator = $proximitySearchIndicator;
        return $this;
    }
}
