<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupCancelRequest upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupPickupCancelRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_pickup\upspickupStruct\Ups_pickupRequestType
     */
    public $Request;
    /**
     * The CancelBy
     * @var string
     */
    public $CancelBy;
    /**
     * The PRN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRN;
    /**
     * Constructor method for PickupCancelRequest
     * @uses Ups_pickupPickupCancelRequest::setRequest()
     * @uses Ups_pickupPickupCancelRequest::setCancelBy()
     * @uses Ups_pickupPickupCancelRequest::setPRN()
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @param string $cancelBy
     * @param string $pRN
     */
    public function __construct(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null, $cancelBy = null, $pRN = null)
    {
        $this
            ->setRequest($request)
            ->setCancelBy($cancelBy)
            ->setPRN($pRN);
    }
    /**
     * Get Request value
     * @return \Ups_pickup\upspickupStruct\Ups_pickupRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_pickup\upspickupStruct\Ups_pickupRequestType $request
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelRequest
     */
    public function setRequest(\Ups_pickup\upspickupStruct\Ups_pickupRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get CancelBy value
     * @return string|null
     */
    public function getCancelBy()
    {
        return $this->CancelBy;
    }
    /**
     * Set CancelBy value
     * @param string $cancelBy
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelRequest
     */
    public function setCancelBy($cancelBy = null)
    {
        // validation for constraint: string
        if (!is_null($cancelBy) && !is_string($cancelBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelBy, true), gettype($cancelBy)), __LINE__);
        }
        $this->CancelBy = $cancelBy;
        return $this;
    }
    /**
     * Get PRN value
     * @return string|null
     */
    public function getPRN()
    {
        return $this->PRN;
    }
    /**
     * Set PRN value
     * @param string $pRN
     * @return \Ups_pickup\upspickupStruct\Ups_pickupPickupCancelRequest
     */
    public function setPRN($pRN = null)
    {
        // validation for constraint: string
        if (!is_null($pRN) && !is_string($pRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRN, true), gettype($pRN)), __LINE__);
        }
        $this->PRN = $pRN;
        return $this;
    }
}
