<?php

namespace Ups_pickup\upspickupStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType upspickupStruct
 * @package Ups_pickup
 * @subpackage Structs
 */
class Ups_pickupAddressType extends AbstractStructBase
{
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The StateProvince
     * @var string
     */
    public $StateProvince;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The ResidentialIndicator
     * Meta information extracted from the WSDL
     * - default: N
     * @var string
     */
    public $ResidentialIndicator;
    /**
     * Constructor method for AddressType
     * @uses Ups_pickupAddressType::setAddressLine()
     * @uses Ups_pickupAddressType::setCity()
     * @uses Ups_pickupAddressType::setStateProvince()
     * @uses Ups_pickupAddressType::setPostalCode()
     * @uses Ups_pickupAddressType::setCountryCode()
     * @uses Ups_pickupAddressType::setResidentialIndicator()
     * @param string[] $addressLine
     * @param string $city
     * @param string $stateProvince
     * @param string $postalCode
     * @param string $countryCode
     * @param string $residentialIndicator
     */
    public function __construct(array $addressLine = array(), $city = null, $stateProvince = null, $postalCode = null, $countryCode = null, $residentialIndicator = 'N')
    {
        $this
            ->setAddressLine($addressLine)
            ->setCity($city)
            ->setStateProvince($stateProvince)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode)
            ->setResidentialIndicator($residentialIndicator);
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressTypeAddressLineItem)) {
                $invalidValues[] = is_object($addressTypeAddressLineItem) ? get_class($addressTypeAddressLineItem) : sprintf('%s(%s)', gettype($addressTypeAddressLineItem), var_export($addressTypeAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvince value
     * @return string|null
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }
    /**
     * Set StateProvince value
     * @param string $stateProvince
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        $this->StateProvince = $stateProvince;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ResidentialIndicator value
     * @return string|null
     */
    public function getResidentialIndicator()
    {
        return $this->ResidentialIndicator;
    }
    /**
     * Set ResidentialIndicator value
     * @param string $residentialIndicator
     * @return \Ups_pickup\upspickupStruct\Ups_pickupAddressType
     */
    public function setResidentialIndicator($residentialIndicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($residentialIndicator) && !is_string($residentialIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialIndicator, true), gettype($residentialIndicator)), __LINE__);
        }
        $this->ResidentialIndicator = $residentialIndicator;
        return $this;
    }
}
