<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebServiceInfo StructType
 * @subpackage Structs
 */
class WebServiceInfo extends AbstractStructBase
{
    /**
     * The NameSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSpace;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The OperationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationName;
    /**
     * The ParameterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParameterName;
    /**
     * Constructor method for WebServiceInfo
     * @uses WebServiceInfo::setNameSpace()
     * @uses WebServiceInfo::setUrl()
     * @uses WebServiceInfo::setOperationName()
     * @uses WebServiceInfo::setParameterName()
     * @param string $nameSpace
     * @param string $url
     * @param string $operationName
     * @param string $parameterName
     */
    public function __construct($nameSpace = null, $url = null, $operationName = null, $parameterName = null)
    {
        $this
            ->setNameSpace($nameSpace)
            ->setUrl($url)
            ->setOperationName($operationName)
            ->setParameterName($parameterName);
    }
    /**
     * Get NameSpace value
     * @return string|null
     */
    public function getNameSpace()
    {
        return $this->NameSpace;
    }
    /**
     * Set NameSpace value
     * @param string $nameSpace
     * @return \StructType\WebServiceInfo
     */
    public function setNameSpace($nameSpace = null)
    {
        // validation for constraint: string
        if (!is_null($nameSpace) && !is_string($nameSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameSpace, true), gettype($nameSpace)), __LINE__);
        }
        $this->NameSpace = $nameSpace;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\WebServiceInfo
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get OperationName value
     * @return string|null
     */
    public function getOperationName()
    {
        return $this->OperationName;
    }
    /**
     * Set OperationName value
     * @param string $operationName
     * @return \StructType\WebServiceInfo
     */
    public function setOperationName($operationName = null)
    {
        // validation for constraint: string
        if (!is_null($operationName) && !is_string($operationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationName, true), gettype($operationName)), __LINE__);
        }
        $this->OperationName = $operationName;
        return $this;
    }
    /**
     * Get ParameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->ParameterName;
    }
    /**
     * Set ParameterName value
     * @param string $parameterName
     * @return \StructType\WebServiceInfo
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        $this->ParameterName = $parameterName;
        return $this;
    }
}
