<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignDocument StructType
 * @subpackage Structs
 */
class SignDocument extends AbstractStructBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentID;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationName;
    /**
     * The SendProcessDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendProcessDate;
    /**
     * The DocumentTopic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTopic;
    /**
     * Constructor method for SignDocument
     * @uses SignDocument::setDocumentID()
     * @uses SignDocument::setLocationName()
     * @uses SignDocument::setSendProcessDate()
     * @uses SignDocument::setDocumentTopic()
     * @param int $documentID
     * @param string $locationName
     * @param string $sendProcessDate
     * @param string $documentTopic
     */
    public function __construct($documentID = null, $locationName = null, $sendProcessDate = null, $documentTopic = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setLocationName($locationName)
            ->setSendProcessDate($sendProcessDate)
            ->setDocumentTopic($documentTopic);
    }
    /**
     * Get DocumentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param int $documentID
     * @return \StructType\SignDocument
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \StructType\SignDocument
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get SendProcessDate value
     * @return string|null
     */
    public function getSendProcessDate()
    {
        return $this->SendProcessDate;
    }
    /**
     * Set SendProcessDate value
     * @param string $sendProcessDate
     * @return \StructType\SignDocument
     */
    public function setSendProcessDate($sendProcessDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendProcessDate) && !is_string($sendProcessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendProcessDate, true), gettype($sendProcessDate)), __LINE__);
        }
        $this->SendProcessDate = $sendProcessDate;
        return $this;
    }
    /**
     * Get DocumentTopic value
     * @return string|null
     */
    public function getDocumentTopic()
    {
        return $this->DocumentTopic;
    }
    /**
     * Set DocumentTopic value
     * @param string $documentTopic
     * @return \StructType\SignDocument
     */
    public function setDocumentTopic($documentTopic = null)
    {
        // validation for constraint: string
        if (!is_null($documentTopic) && !is_string($documentTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTopic, true), gettype($documentTopic)), __LINE__);
        }
        $this->DocumentTopic = $documentTopic;
        return $this;
    }
}
