<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveObjectGS StructType
 * @subpackage Structs
 */
class SaveObjectGS extends AbstractStructBase
{
    /**
     * The documentObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $documentObject;
    /**
     * The modeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $modeType;
    /**
     * The refObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $refObjectID;
    /**
     * Constructor method for SaveObjectGS
     * @uses SaveObjectGS::setDocumentObject()
     * @uses SaveObjectGS::setModeType()
     * @uses SaveObjectGS::setRefObjectID()
     * @param \StructType\Document $documentObject
     * @param string $modeType
     * @param string $refObjectID
     */
    public function __construct(\StructType\Document $documentObject = null, $modeType = null, $refObjectID = null)
    {
        $this
            ->setDocumentObject($documentObject)
            ->setModeType($modeType)
            ->setRefObjectID($refObjectID);
    }
    /**
     * Get documentObject value
     * @return \StructType\Document|null
     */
    public function getDocumentObject()
    {
        return $this->documentObject;
    }
    /**
     * Set documentObject value
     * @param \StructType\Document $documentObject
     * @return \StructType\SaveObjectGS
     */
    public function setDocumentObject(\StructType\Document $documentObject = null)
    {
        $this->documentObject = $documentObject;
        return $this;
    }
    /**
     * Get modeType value
     * @return string|null
     */
    public function getModeType()
    {
        return $this->modeType;
    }
    /**
     * Set modeType value
     * @param string $modeType
     * @return \StructType\SaveObjectGS
     */
    public function setModeType($modeType = null)
    {
        // validation for constraint: string
        if (!is_null($modeType) && !is_string($modeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeType, true), gettype($modeType)), __LINE__);
        }
        $this->modeType = $modeType;
        return $this;
    }
    /**
     * Get refObjectID value
     * @return string|null
     */
    public function getRefObjectID()
    {
        return $this->refObjectID;
    }
    /**
     * Set refObjectID value
     * @param string $refObjectID
     * @return \StructType\SaveObjectGS
     */
    public function setRefObjectID($refObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($refObjectID) && !is_string($refObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refObjectID, true), gettype($refObjectID)), __LINE__);
        }
        $this->refObjectID = $refObjectID;
        return $this;
    }
}
