<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saveDocumentTypeProfileValuesPrinter StructType
 * @subpackage Structs
 */
class SaveDocumentTypeProfileValuesPrinter extends AbstractStructBase
{
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The profileValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocumentTypeProfileValuePrinter
     */
    public $profileValue;
    /**
     * Constructor method for saveDocumentTypeProfileValuesPrinter
     * @uses SaveDocumentTypeProfileValuesPrinter::setDocumentID()
     * @uses SaveDocumentTypeProfileValuesPrinter::setProfileValue()
     * @param int $documentID
     * @param \ArrayType\ArrayOfDocumentTypeProfileValuePrinter $profileValue
     */
    public function __construct($documentID = null, \ArrayType\ArrayOfDocumentTypeProfileValuePrinter $profileValue = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setProfileValue($profileValue);
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \StructType\SaveDocumentTypeProfileValuesPrinter
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get profileValue value
     * @return \ArrayType\ArrayOfDocumentTypeProfileValuePrinter|null
     */
    public function getProfileValue()
    {
        return $this->profileValue;
    }
    /**
     * Set profileValue value
     * @param \ArrayType\ArrayOfDocumentTypeProfileValuePrinter $profileValue
     * @return \StructType\SaveDocumentTypeProfileValuesPrinter
     */
    public function setProfileValue(\ArrayType\ArrayOfDocumentTypeProfileValuePrinter $profileValue = null)
    {
        $this->profileValue = $profileValue;
        return $this;
    }
}
