<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostDocumentDataGS StructType
 * @subpackage Structs
 */
class PostDocumentDataGS extends AbstractStructBase
{
    /**
     * The documentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentData;
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extension;
    /**
     * Constructor method for PostDocumentDataGS
     * @uses PostDocumentDataGS::setDocumentData()
     * @uses PostDocumentDataGS::setExtension()
     * @param string $documentData
     * @param string $extension
     */
    public function __construct($documentData = null, $extension = null)
    {
        $this
            ->setDocumentData($documentData)
            ->setExtension($extension);
    }
    /**
     * Get documentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->documentData;
    }
    /**
     * Set documentData value
     * @param string $documentData
     * @return \StructType\PostDocumentDataGS
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->documentData = $documentData;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \StructType\PostDocumentDataGS
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
}
