<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DynamicWorkFlow StructType
 * @subpackage Structs
 */
class DynamicWorkFlow extends AbstractStructBase
{
    /**
     * The ChairID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChairID;
    /**
     * The SignatureType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SignatureType;
    /**
     * The DesignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DesignID;
    /**
     * The ChairName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChairName;
    /**
     * Constructor method for DynamicWorkFlow
     * @uses DynamicWorkFlow::setChairID()
     * @uses DynamicWorkFlow::setSignatureType()
     * @uses DynamicWorkFlow::setDesignID()
     * @uses DynamicWorkFlow::setChairName()
     * @param int $chairID
     * @param int $signatureType
     * @param int $designID
     * @param string $chairName
     */
    public function __construct($chairID = null, $signatureType = null, $designID = null, $chairName = null)
    {
        $this
            ->setChairID($chairID)
            ->setSignatureType($signatureType)
            ->setDesignID($designID)
            ->setChairName($chairName);
    }
    /**
     * Get ChairID value
     * @return int
     */
    public function getChairID()
    {
        return $this->ChairID;
    }
    /**
     * Set ChairID value
     * @param int $chairID
     * @return \StructType\DynamicWorkFlow
     */
    public function setChairID($chairID = null)
    {
        // validation for constraint: int
        if (!is_null($chairID) && !(is_int($chairID) || ctype_digit($chairID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chairID, true), gettype($chairID)), __LINE__);
        }
        $this->ChairID = $chairID;
        return $this;
    }
    /**
     * Get SignatureType value
     * @return int
     */
    public function getSignatureType()
    {
        return $this->SignatureType;
    }
    /**
     * Set SignatureType value
     * @param int $signatureType
     * @return \StructType\DynamicWorkFlow
     */
    public function setSignatureType($signatureType = null)
    {
        // validation for constraint: int
        if (!is_null($signatureType) && !(is_int($signatureType) || ctype_digit($signatureType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($signatureType, true), gettype($signatureType)), __LINE__);
        }
        $this->SignatureType = $signatureType;
        return $this;
    }
    /**
     * Get DesignID value
     * @return int
     */
    public function getDesignID()
    {
        return $this->DesignID;
    }
    /**
     * Set DesignID value
     * @param int $designID
     * @return \StructType\DynamicWorkFlow
     */
    public function setDesignID($designID = null)
    {
        // validation for constraint: int
        if (!is_null($designID) && !(is_int($designID) || ctype_digit($designID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($designID, true), gettype($designID)), __LINE__);
        }
        $this->DesignID = $designID;
        return $this;
    }
    /**
     * Get ChairName value
     * @return string|null
     */
    public function getChairName()
    {
        return $this->ChairName;
    }
    /**
     * Set ChairName value
     * @param string $chairName
     * @return \StructType\DynamicWorkFlow
     */
    public function setChairName($chairName = null)
    {
        // validation for constraint: string
        if (!is_null($chairName) && !is_string($chairName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chairName, true), gettype($chairName)), __LINE__);
        }
        $this->ChairName = $chairName;
        return $this;
    }
}
