<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The OwnerSecurityLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerSecurityLevel;
    /**
     * The HasWorkFlowProcess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasWorkFlowProcess;
    /**
     * The IsWorkFlowFinished
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWorkFlowFinished;
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjectID;
    /**
     * The OwnerFolderOID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerFolderOID;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The CreatorUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatorUserID;
    /**
     * The ChairID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChairID;
    /**
     * The PrivacyDegreeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PrivacyDegreeID;
    /**
     * The DocumentTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentTypeID;
    /**
     * The LanguageID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The EmergencyDegreeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EmergencyDegreeID;
    /**
     * The IsCancelled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCancelled;
    /**
     * The LockerChairID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LockerChairID;
    /**
     * The IsGetInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsGetInfo;
    /**
     * The IsIndividualInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIndividualInfo;
    /**
     * The IsOfficialDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOfficialDocument;
    /**
     * The IsCopy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCopy;
    /**
     * The CopiedFromID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CopiedFromID;
    /**
     * The IndividualInfoUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IndividualInfoUserID;
    /**
     * The SendLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SendLocation;
    /**
     * The IsPhysical
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPhysical;
    /**
     * The IsCopyrightContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCopyrightContent;
    /**
     * The IsPrivateToOwner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrivateToOwner;
    /**
     * The CameLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CameLocation;
    /**
     * The IsCameLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCameLocation;
    /**
     * The EmailID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EmailID;
    /**
     * The SignedDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SignedDocument;
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TimeStamp;
    /**
     * The CryptionAlgorithm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CryptionAlgorithm;
    /**
     * The IncomeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IncomeType;
    /**
     * The OutgoType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutgoType;
    /**
     * The ScopeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScopeID;
    /**
     * The TemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TemplateID;
    /**
     * The DocumentUnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentUnitId;
    /**
     * The DocumentHash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentHash;
    /**
     * The CycleEnded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CycleEnded;
    /**
     * The QuickWorkFlowID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuickWorkFlowID;
    /**
     * The IsSigned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSigned;
    /**
     * The SentCheck
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SentCheck;
    /**
     * The IsInArchive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInArchive;
    /**
     * The OwnerArchiveFolderOID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerArchiveFolderOID;
    /**
     * The CheckSendLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CheckSendLocation;
    /**
     * The ImhaKomisyonNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ImhaKomisyonNo;
    /**
     * The HasPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasPassword;
    /**
     * The IncomingDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IncomingDocType;
    /**
     * The CompleteWFprocess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CompleteWFprocess;
    /**
     * The IsConfirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsConfirmation;
    /**
     * The IsOCR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOCR;
    /**
     * The SystemPropertyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemPropertyId;
    /**
     * The TemplateCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TemplateCount;
    /**
     * The IsDestroyed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDestroyed;
    /**
     * The IsArchived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsArchived;
    /**
     * The DocumentSystemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SystemProperty
     */
    public $DocumentSystemProperty;
    /**
     * The AppendixInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAppendix
     */
    public $AppendixInfo;
    /**
     * The DistributionlistInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDistributionlist
     */
    public $DistributionlistInfo;
    /**
     * The ArchiveStoreTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfArchiveStore
     */
    public $ArchiveStoreTypes;
    /**
     * The SecurityLevels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSecurityLevelShortInfo
     */
    public $SecurityLevels;
    /**
     * The DocumentArchiveStore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ArchiveStore
     */
    public $DocumentArchiveStore;
    /**
     * The OwnersSerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnersSerialNumber;
    /**
     * The PostedFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostedFileName;
    /**
     * The ScannedProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ScannedImageProperties
     */
    public $ScannedProperties;
    /**
     * The DocumentTopic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTopic;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentName;
    /**
     * The DocumentOwner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentOwner;
    /**
     * The DocumentUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentUnit;
    /**
     * The DocumentPlanNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentPlanNo;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentDescription;
    /**
     * The CancellationReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CancellationReason;
    /**
     * The PhysicalDocumentPath
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhysicalDocumentPath;
    /**
     * The DocumentKeywords
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentKeywords;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNo;
    /**
     * The SendLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendLocationName;
    /**
     * The CameLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CameLocationName;
    /**
     * The IndividualInfoUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndividualInfoUserName;
    /**
     * The OwnerUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerUserName;
    /**
     * The UploadedFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UploadedFileName;
    /**
     * The ArchiveFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArchiveFormat;
    /**
     * The DigitalSigns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DigitalSigns;
    /**
     * The DocumentEntranceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentEntranceDate;
    /**
     * The DocumentEntranceTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentEntranceTime;
    /**
     * The CameDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CameDate;
    /**
     * The CameNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CameNumber;
    /**
     * The ESHS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ESHS;
    /**
     * The MailDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailDate;
    /**
     * The ScopeIDText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScopeIDText;
    /**
     * The DocumentWriterUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentWriterUnit;
    /**
     * The ContentText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentText;
    /**
     * The DeliveredPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveredPerson;
    /**
     * The SendedDocumentDeliveredPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendedDocumentDeliveredPerson;
    /**
     * The AppendixText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppendixText;
    /**
     * The RelatedText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelatedText;
    /**
     * The ConfirmationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationCode;
    /**
     * The PhysicalFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhysicalFileName;
    /**
     * The FileChangedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileChangedDate;
    /**
     * The DocumentNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNote;
    /**
     * The RejectedChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RejectedChange;
    /**
     * The ArchiveEntranceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArchiveEntranceDate;
    /**
     * The DocumentPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentPassword;
    /**
     * The LockerUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LockerUserName;
    /**
     * The IncomingDocSenderTCNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncomingDocSenderTCNumber;
    /**
     * The DistributionEditor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionEditor;
    /**
     * The ExtraItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraItem;
    /**
     * The TemplateCountMontly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateCountMontly;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationName;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The PublishStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PublishStatus;
    /**
     * Constructor method for Document
     * @uses Document::setOwnerSecurityLevel()
     * @uses Document::setHasWorkFlowProcess()
     * @uses Document::setIsWorkFlowFinished()
     * @uses Document::setObjectID()
     * @uses Document::setOwnerFolderOID()
     * @uses Document::setIsDeleted()
     * @uses Document::setCreatorUserID()
     * @uses Document::setChairID()
     * @uses Document::setPrivacyDegreeID()
     * @uses Document::setDocumentTypeID()
     * @uses Document::setLanguageID()
     * @uses Document::setEmergencyDegreeID()
     * @uses Document::setIsCancelled()
     * @uses Document::setLockerChairID()
     * @uses Document::setIsGetInfo()
     * @uses Document::setIsIndividualInfo()
     * @uses Document::setIsOfficialDocument()
     * @uses Document::setIsCopy()
     * @uses Document::setCopiedFromID()
     * @uses Document::setIndividualInfoUserID()
     * @uses Document::setSendLocation()
     * @uses Document::setIsPhysical()
     * @uses Document::setIsCopyrightContent()
     * @uses Document::setIsPrivateToOwner()
     * @uses Document::setCameLocation()
     * @uses Document::setIsCameLocation()
     * @uses Document::setEmailID()
     * @uses Document::setSignedDocument()
     * @uses Document::setTimeStamp()
     * @uses Document::setCryptionAlgorithm()
     * @uses Document::setIncomeType()
     * @uses Document::setOutgoType()
     * @uses Document::setScopeID()
     * @uses Document::setTemplateID()
     * @uses Document::setDocumentUnitId()
     * @uses Document::setDocumentHash()
     * @uses Document::setCycleEnded()
     * @uses Document::setQuickWorkFlowID()
     * @uses Document::setIsSigned()
     * @uses Document::setSentCheck()
     * @uses Document::setIsInArchive()
     * @uses Document::setOwnerArchiveFolderOID()
     * @uses Document::setCheckSendLocation()
     * @uses Document::setImhaKomisyonNo()
     * @uses Document::setHasPassword()
     * @uses Document::setIncomingDocType()
     * @uses Document::setCompleteWFprocess()
     * @uses Document::setIsConfirmation()
     * @uses Document::setIsOCR()
     * @uses Document::setSystemPropertyId()
     * @uses Document::setTemplateCount()
     * @uses Document::setIsDestroyed()
     * @uses Document::setIsArchived()
     * @uses Document::setDocumentSystemProperty()
     * @uses Document::setAppendixInfo()
     * @uses Document::setDistributionlistInfo()
     * @uses Document::setArchiveStoreTypes()
     * @uses Document::setSecurityLevels()
     * @uses Document::setDocumentArchiveStore()
     * @uses Document::setOwnersSerialNumber()
     * @uses Document::setPostedFileName()
     * @uses Document::setScannedProperties()
     * @uses Document::setDocumentTopic()
     * @uses Document::setDocumentName()
     * @uses Document::setDocumentOwner()
     * @uses Document::setDocumentUnit()
     * @uses Document::setDocumentPlanNo()
     * @uses Document::setDocumentDescription()
     * @uses Document::setCancellationReason()
     * @uses Document::setPhysicalDocumentPath()
     * @uses Document::setDocumentKeywords()
     * @uses Document::setDocumentDate()
     * @uses Document::setDocumentNo()
     * @uses Document::setSendLocationName()
     * @uses Document::setCameLocationName()
     * @uses Document::setIndividualInfoUserName()
     * @uses Document::setOwnerUserName()
     * @uses Document::setUploadedFileName()
     * @uses Document::setArchiveFormat()
     * @uses Document::setDigitalSigns()
     * @uses Document::setDocumentEntranceDate()
     * @uses Document::setDocumentEntranceTime()
     * @uses Document::setCameDate()
     * @uses Document::setCameNumber()
     * @uses Document::setESHS()
     * @uses Document::setMailDate()
     * @uses Document::setScopeIDText()
     * @uses Document::setDocumentWriterUnit()
     * @uses Document::setContentText()
     * @uses Document::setDeliveredPerson()
     * @uses Document::setSendedDocumentDeliveredPerson()
     * @uses Document::setAppendixText()
     * @uses Document::setRelatedText()
     * @uses Document::setConfirmationCode()
     * @uses Document::setPhysicalFileName()
     * @uses Document::setFileChangedDate()
     * @uses Document::setDocumentNote()
     * @uses Document::setRejectedChange()
     * @uses Document::setArchiveEntranceDate()
     * @uses Document::setDocumentPassword()
     * @uses Document::setLockerUserName()
     * @uses Document::setIncomingDocSenderTCNumber()
     * @uses Document::setDistributionEditor()
     * @uses Document::setExtraItem()
     * @uses Document::setTemplateCountMontly()
     * @uses Document::setLocationName()
     * @uses Document::setFileName()
     * @uses Document::setPublishStatus()
     * @param int $ownerSecurityLevel
     * @param bool $hasWorkFlowProcess
     * @param bool $isWorkFlowFinished
     * @param int $objectID
     * @param int $ownerFolderOID
     * @param bool $isDeleted
     * @param int $creatorUserID
     * @param int $chairID
     * @param int $privacyDegreeID
     * @param int $documentTypeID
     * @param int $languageID
     * @param int $emergencyDegreeID
     * @param bool $isCancelled
     * @param int $lockerChairID
     * @param bool $isGetInfo
     * @param bool $isIndividualInfo
     * @param bool $isOfficialDocument
     * @param bool $isCopy
     * @param int $copiedFromID
     * @param int $individualInfoUserID
     * @param int $sendLocation
     * @param bool $isPhysical
     * @param bool $isCopyrightContent
     * @param bool $isPrivateToOwner
     * @param int $cameLocation
     * @param bool $isCameLocation
     * @param int $emailID
     * @param bool $signedDocument
     * @param bool $timeStamp
     * @param bool $cryptionAlgorithm
     * @param int $incomeType
     * @param int $outgoType
     * @param int $scopeID
     * @param int $templateID
     * @param int $documentUnitId
     * @param int $documentHash
     * @param bool $cycleEnded
     * @param int $quickWorkFlowID
     * @param bool $isSigned
     * @param bool $sentCheck
     * @param bool $isInArchive
     * @param int $ownerArchiveFolderOID
     * @param bool $checkSendLocation
     * @param int $imhaKomisyonNo
     * @param bool $hasPassword
     * @param int $incomingDocType
     * @param bool $completeWFprocess
     * @param bool $isConfirmation
     * @param bool $isOCR
     * @param int $systemPropertyId
     * @param int $templateCount
     * @param bool $isDestroyed
     * @param bool $isArchived
     * @param \StructType\SystemProperty $documentSystemProperty
     * @param \ArrayType\ArrayOfAppendix $appendixInfo
     * @param \ArrayType\ArrayOfDistributionlist $distributionlistInfo
     * @param \ArrayType\ArrayOfArchiveStore $archiveStoreTypes
     * @param \ArrayType\ArrayOfSecurityLevelShortInfo $securityLevels
     * @param \StructType\ArchiveStore $documentArchiveStore
     * @param string $ownersSerialNumber
     * @param string $postedFileName
     * @param \StructType\ScannedImageProperties $scannedProperties
     * @param string $documentTopic
     * @param string $documentName
     * @param string $documentOwner
     * @param string $documentUnit
     * @param string $documentPlanNo
     * @param string $documentDescription
     * @param string $cancellationReason
     * @param string $physicalDocumentPath
     * @param string $documentKeywords
     * @param string $documentDate
     * @param string $documentNo
     * @param string $sendLocationName
     * @param string $cameLocationName
     * @param string $individualInfoUserName
     * @param string $ownerUserName
     * @param string $uploadedFileName
     * @param string $archiveFormat
     * @param string $digitalSigns
     * @param string $documentEntranceDate
     * @param string $documentEntranceTime
     * @param string $cameDate
     * @param string $cameNumber
     * @param string $eSHS
     * @param string $mailDate
     * @param string $scopeIDText
     * @param string $documentWriterUnit
     * @param string $contentText
     * @param string $deliveredPerson
     * @param string $sendedDocumentDeliveredPerson
     * @param string $appendixText
     * @param string $relatedText
     * @param string $confirmationCode
     * @param string $physicalFileName
     * @param string $fileChangedDate
     * @param string $documentNote
     * @param string $rejectedChange
     * @param string $archiveEntranceDate
     * @param string $documentPassword
     * @param string $lockerUserName
     * @param string $incomingDocSenderTCNumber
     * @param string $distributionEditor
     * @param string $extraItem
     * @param string $templateCountMontly
     * @param string $locationName
     * @param string $fileName
     * @param string $publishStatus
     */
    public function __construct($ownerSecurityLevel = null, $hasWorkFlowProcess = null, $isWorkFlowFinished = null, $objectID = null, $ownerFolderOID = null, $isDeleted = null, $creatorUserID = null, $chairID = null, $privacyDegreeID = null, $documentTypeID = null, $languageID = null, $emergencyDegreeID = null, $isCancelled = null, $lockerChairID = null, $isGetInfo = null, $isIndividualInfo = null, $isOfficialDocument = null, $isCopy = null, $copiedFromID = null, $individualInfoUserID = null, $sendLocation = null, $isPhysical = null, $isCopyrightContent = null, $isPrivateToOwner = null, $cameLocation = null, $isCameLocation = null, $emailID = null, $signedDocument = null, $timeStamp = null, $cryptionAlgorithm = null, $incomeType = null, $outgoType = null, $scopeID = null, $templateID = null, $documentUnitId = null, $documentHash = null, $cycleEnded = null, $quickWorkFlowID = null, $isSigned = null, $sentCheck = null, $isInArchive = null, $ownerArchiveFolderOID = null, $checkSendLocation = null, $imhaKomisyonNo = null, $hasPassword = null, $incomingDocType = null, $completeWFprocess = null, $isConfirmation = null, $isOCR = null, $systemPropertyId = null, $templateCount = null, $isDestroyed = null, $isArchived = null, \StructType\SystemProperty $documentSystemProperty = null, \ArrayType\ArrayOfAppendix $appendixInfo = null, \ArrayType\ArrayOfDistributionlist $distributionlistInfo = null, \ArrayType\ArrayOfArchiveStore $archiveStoreTypes = null, \ArrayType\ArrayOfSecurityLevelShortInfo $securityLevels = null, \StructType\ArchiveStore $documentArchiveStore = null, $ownersSerialNumber = null, $postedFileName = null, \StructType\ScannedImageProperties $scannedProperties = null, $documentTopic = null, $documentName = null, $documentOwner = null, $documentUnit = null, $documentPlanNo = null, $documentDescription = null, $cancellationReason = null, $physicalDocumentPath = null, $documentKeywords = null, $documentDate = null, $documentNo = null, $sendLocationName = null, $cameLocationName = null, $individualInfoUserName = null, $ownerUserName = null, $uploadedFileName = null, $archiveFormat = null, $digitalSigns = null, $documentEntranceDate = null, $documentEntranceTime = null, $cameDate = null, $cameNumber = null, $eSHS = null, $mailDate = null, $scopeIDText = null, $documentWriterUnit = null, $contentText = null, $deliveredPerson = null, $sendedDocumentDeliveredPerson = null, $appendixText = null, $relatedText = null, $confirmationCode = null, $physicalFileName = null, $fileChangedDate = null, $documentNote = null, $rejectedChange = null, $archiveEntranceDate = null, $documentPassword = null, $lockerUserName = null, $incomingDocSenderTCNumber = null, $distributionEditor = null, $extraItem = null, $templateCountMontly = null, $locationName = null, $fileName = null, $publishStatus = null)
    {
        $this
            ->setOwnerSecurityLevel($ownerSecurityLevel)
            ->setHasWorkFlowProcess($hasWorkFlowProcess)
            ->setIsWorkFlowFinished($isWorkFlowFinished)
            ->setObjectID($objectID)
            ->setOwnerFolderOID($ownerFolderOID)
            ->setIsDeleted($isDeleted)
            ->setCreatorUserID($creatorUserID)
            ->setChairID($chairID)
            ->setPrivacyDegreeID($privacyDegreeID)
            ->setDocumentTypeID($documentTypeID)
            ->setLanguageID($languageID)
            ->setEmergencyDegreeID($emergencyDegreeID)
            ->setIsCancelled($isCancelled)
            ->setLockerChairID($lockerChairID)
            ->setIsGetInfo($isGetInfo)
            ->setIsIndividualInfo($isIndividualInfo)
            ->setIsOfficialDocument($isOfficialDocument)
            ->setIsCopy($isCopy)
            ->setCopiedFromID($copiedFromID)
            ->setIndividualInfoUserID($individualInfoUserID)
            ->setSendLocation($sendLocation)
            ->setIsPhysical($isPhysical)
            ->setIsCopyrightContent($isCopyrightContent)
            ->setIsPrivateToOwner($isPrivateToOwner)
            ->setCameLocation($cameLocation)
            ->setIsCameLocation($isCameLocation)
            ->setEmailID($emailID)
            ->setSignedDocument($signedDocument)
            ->setTimeStamp($timeStamp)
            ->setCryptionAlgorithm($cryptionAlgorithm)
            ->setIncomeType($incomeType)
            ->setOutgoType($outgoType)
            ->setScopeID($scopeID)
            ->setTemplateID($templateID)
            ->setDocumentUnitId($documentUnitId)
            ->setDocumentHash($documentHash)
            ->setCycleEnded($cycleEnded)
            ->setQuickWorkFlowID($quickWorkFlowID)
            ->setIsSigned($isSigned)
            ->setSentCheck($sentCheck)
            ->setIsInArchive($isInArchive)
            ->setOwnerArchiveFolderOID($ownerArchiveFolderOID)
            ->setCheckSendLocation($checkSendLocation)
            ->setImhaKomisyonNo($imhaKomisyonNo)
            ->setHasPassword($hasPassword)
            ->setIncomingDocType($incomingDocType)
            ->setCompleteWFprocess($completeWFprocess)
            ->setIsConfirmation($isConfirmation)
            ->setIsOCR($isOCR)
            ->setSystemPropertyId($systemPropertyId)
            ->setTemplateCount($templateCount)
            ->setIsDestroyed($isDestroyed)
            ->setIsArchived($isArchived)
            ->setDocumentSystemProperty($documentSystemProperty)
            ->setAppendixInfo($appendixInfo)
            ->setDistributionlistInfo($distributionlistInfo)
            ->setArchiveStoreTypes($archiveStoreTypes)
            ->setSecurityLevels($securityLevels)
            ->setDocumentArchiveStore($documentArchiveStore)
            ->setOwnersSerialNumber($ownersSerialNumber)
            ->setPostedFileName($postedFileName)
            ->setScannedProperties($scannedProperties)
            ->setDocumentTopic($documentTopic)
            ->setDocumentName($documentName)
            ->setDocumentOwner($documentOwner)
            ->setDocumentUnit($documentUnit)
            ->setDocumentPlanNo($documentPlanNo)
            ->setDocumentDescription($documentDescription)
            ->setCancellationReason($cancellationReason)
            ->setPhysicalDocumentPath($physicalDocumentPath)
            ->setDocumentKeywords($documentKeywords)
            ->setDocumentDate($documentDate)
            ->setDocumentNo($documentNo)
            ->setSendLocationName($sendLocationName)
            ->setCameLocationName($cameLocationName)
            ->setIndividualInfoUserName($individualInfoUserName)
            ->setOwnerUserName($ownerUserName)
            ->setUploadedFileName($uploadedFileName)
            ->setArchiveFormat($archiveFormat)
            ->setDigitalSigns($digitalSigns)
            ->setDocumentEntranceDate($documentEntranceDate)
            ->setDocumentEntranceTime($documentEntranceTime)
            ->setCameDate($cameDate)
            ->setCameNumber($cameNumber)
            ->setESHS($eSHS)
            ->setMailDate($mailDate)
            ->setScopeIDText($scopeIDText)
            ->setDocumentWriterUnit($documentWriterUnit)
            ->setContentText($contentText)
            ->setDeliveredPerson($deliveredPerson)
            ->setSendedDocumentDeliveredPerson($sendedDocumentDeliveredPerson)
            ->setAppendixText($appendixText)
            ->setRelatedText($relatedText)
            ->setConfirmationCode($confirmationCode)
            ->setPhysicalFileName($physicalFileName)
            ->setFileChangedDate($fileChangedDate)
            ->setDocumentNote($documentNote)
            ->setRejectedChange($rejectedChange)
            ->setArchiveEntranceDate($archiveEntranceDate)
            ->setDocumentPassword($documentPassword)
            ->setLockerUserName($lockerUserName)
            ->setIncomingDocSenderTCNumber($incomingDocSenderTCNumber)
            ->setDistributionEditor($distributionEditor)
            ->setExtraItem($extraItem)
            ->setTemplateCountMontly($templateCountMontly)
            ->setLocationName($locationName)
            ->setFileName($fileName)
            ->setPublishStatus($publishStatus);
    }
    /**
     * Get OwnerSecurityLevel value
     * @return int
     */
    public function getOwnerSecurityLevel()
    {
        return $this->OwnerSecurityLevel;
    }
    /**
     * Set OwnerSecurityLevel value
     * @param int $ownerSecurityLevel
     * @return \StructType\Document
     */
    public function setOwnerSecurityLevel($ownerSecurityLevel = null)
    {
        // validation for constraint: int
        if (!is_null($ownerSecurityLevel) && !(is_int($ownerSecurityLevel) || ctype_digit($ownerSecurityLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerSecurityLevel, true), gettype($ownerSecurityLevel)), __LINE__);
        }
        $this->OwnerSecurityLevel = $ownerSecurityLevel;
        return $this;
    }
    /**
     * Get HasWorkFlowProcess value
     * @return bool
     */
    public function getHasWorkFlowProcess()
    {
        return $this->HasWorkFlowProcess;
    }
    /**
     * Set HasWorkFlowProcess value
     * @param bool $hasWorkFlowProcess
     * @return \StructType\Document
     */
    public function setHasWorkFlowProcess($hasWorkFlowProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasWorkFlowProcess) && !is_bool($hasWorkFlowProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasWorkFlowProcess, true), gettype($hasWorkFlowProcess)), __LINE__);
        }
        $this->HasWorkFlowProcess = $hasWorkFlowProcess;
        return $this;
    }
    /**
     * Get IsWorkFlowFinished value
     * @return bool
     */
    public function getIsWorkFlowFinished()
    {
        return $this->IsWorkFlowFinished;
    }
    /**
     * Set IsWorkFlowFinished value
     * @param bool $isWorkFlowFinished
     * @return \StructType\Document
     */
    public function setIsWorkFlowFinished($isWorkFlowFinished = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWorkFlowFinished) && !is_bool($isWorkFlowFinished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWorkFlowFinished, true), gettype($isWorkFlowFinished)), __LINE__);
        }
        $this->IsWorkFlowFinished = $isWorkFlowFinished;
        return $this;
    }
    /**
     * Get ObjectID value
     * @return int
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param int $objectID
     * @return \StructType\Document
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get OwnerFolderOID value
     * @return int
     */
    public function getOwnerFolderOID()
    {
        return $this->OwnerFolderOID;
    }
    /**
     * Set OwnerFolderOID value
     * @param int $ownerFolderOID
     * @return \StructType\Document
     */
    public function setOwnerFolderOID($ownerFolderOID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerFolderOID) && !(is_int($ownerFolderOID) || ctype_digit($ownerFolderOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerFolderOID, true), gettype($ownerFolderOID)), __LINE__);
        }
        $this->OwnerFolderOID = $ownerFolderOID;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\Document
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get CreatorUserID value
     * @return int
     */
    public function getCreatorUserID()
    {
        return $this->CreatorUserID;
    }
    /**
     * Set CreatorUserID value
     * @param int $creatorUserID
     * @return \StructType\Document
     */
    public function setCreatorUserID($creatorUserID = null)
    {
        // validation for constraint: int
        if (!is_null($creatorUserID) && !(is_int($creatorUserID) || ctype_digit($creatorUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creatorUserID, true), gettype($creatorUserID)), __LINE__);
        }
        $this->CreatorUserID = $creatorUserID;
        return $this;
    }
    /**
     * Get ChairID value
     * @return int
     */
    public function getChairID()
    {
        return $this->ChairID;
    }
    /**
     * Set ChairID value
     * @param int $chairID
     * @return \StructType\Document
     */
    public function setChairID($chairID = null)
    {
        // validation for constraint: int
        if (!is_null($chairID) && !(is_int($chairID) || ctype_digit($chairID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chairID, true), gettype($chairID)), __LINE__);
        }
        $this->ChairID = $chairID;
        return $this;
    }
    /**
     * Get PrivacyDegreeID value
     * @return int
     */
    public function getPrivacyDegreeID()
    {
        return $this->PrivacyDegreeID;
    }
    /**
     * Set PrivacyDegreeID value
     * @param int $privacyDegreeID
     * @return \StructType\Document
     */
    public function setPrivacyDegreeID($privacyDegreeID = null)
    {
        // validation for constraint: int
        if (!is_null($privacyDegreeID) && !(is_int($privacyDegreeID) || ctype_digit($privacyDegreeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privacyDegreeID, true), gettype($privacyDegreeID)), __LINE__);
        }
        $this->PrivacyDegreeID = $privacyDegreeID;
        return $this;
    }
    /**
     * Get DocumentTypeID value
     * @return int
     */
    public function getDocumentTypeID()
    {
        return $this->DocumentTypeID;
    }
    /**
     * Set DocumentTypeID value
     * @param int $documentTypeID
     * @return \StructType\Document
     */
    public function setDocumentTypeID($documentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($documentTypeID) && !(is_int($documentTypeID) || ctype_digit($documentTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentTypeID, true), gettype($documentTypeID)), __LINE__);
        }
        $this->DocumentTypeID = $documentTypeID;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\Document
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !(is_int($languageID) || ctype_digit($languageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($languageID, true), gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get EmergencyDegreeID value
     * @return int
     */
    public function getEmergencyDegreeID()
    {
        return $this->EmergencyDegreeID;
    }
    /**
     * Set EmergencyDegreeID value
     * @param int $emergencyDegreeID
     * @return \StructType\Document
     */
    public function setEmergencyDegreeID($emergencyDegreeID = null)
    {
        // validation for constraint: int
        if (!is_null($emergencyDegreeID) && !(is_int($emergencyDegreeID) || ctype_digit($emergencyDegreeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emergencyDegreeID, true), gettype($emergencyDegreeID)), __LINE__);
        }
        $this->EmergencyDegreeID = $emergencyDegreeID;
        return $this;
    }
    /**
     * Get IsCancelled value
     * @return bool
     */
    public function getIsCancelled()
    {
        return $this->IsCancelled;
    }
    /**
     * Set IsCancelled value
     * @param bool $isCancelled
     * @return \StructType\Document
     */
    public function setIsCancelled($isCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCancelled) && !is_bool($isCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCancelled, true), gettype($isCancelled)), __LINE__);
        }
        $this->IsCancelled = $isCancelled;
        return $this;
    }
    /**
     * Get LockerChairID value
     * @return int
     */
    public function getLockerChairID()
    {
        return $this->LockerChairID;
    }
    /**
     * Set LockerChairID value
     * @param int $lockerChairID
     * @return \StructType\Document
     */
    public function setLockerChairID($lockerChairID = null)
    {
        // validation for constraint: int
        if (!is_null($lockerChairID) && !(is_int($lockerChairID) || ctype_digit($lockerChairID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lockerChairID, true), gettype($lockerChairID)), __LINE__);
        }
        $this->LockerChairID = $lockerChairID;
        return $this;
    }
    /**
     * Get IsGetInfo value
     * @return bool
     */
    public function getIsGetInfo()
    {
        return $this->IsGetInfo;
    }
    /**
     * Set IsGetInfo value
     * @param bool $isGetInfo
     * @return \StructType\Document
     */
    public function setIsGetInfo($isGetInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetInfo) && !is_bool($isGetInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetInfo, true), gettype($isGetInfo)), __LINE__);
        }
        $this->IsGetInfo = $isGetInfo;
        return $this;
    }
    /**
     * Get IsIndividualInfo value
     * @return bool
     */
    public function getIsIndividualInfo()
    {
        return $this->IsIndividualInfo;
    }
    /**
     * Set IsIndividualInfo value
     * @param bool $isIndividualInfo
     * @return \StructType\Document
     */
    public function setIsIndividualInfo($isIndividualInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIndividualInfo) && !is_bool($isIndividualInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIndividualInfo, true), gettype($isIndividualInfo)), __LINE__);
        }
        $this->IsIndividualInfo = $isIndividualInfo;
        return $this;
    }
    /**
     * Get IsOfficialDocument value
     * @return bool
     */
    public function getIsOfficialDocument()
    {
        return $this->IsOfficialDocument;
    }
    /**
     * Set IsOfficialDocument value
     * @param bool $isOfficialDocument
     * @return \StructType\Document
     */
    public function setIsOfficialDocument($isOfficialDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOfficialDocument) && !is_bool($isOfficialDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOfficialDocument, true), gettype($isOfficialDocument)), __LINE__);
        }
        $this->IsOfficialDocument = $isOfficialDocument;
        return $this;
    }
    /**
     * Get IsCopy value
     * @return bool
     */
    public function getIsCopy()
    {
        return $this->IsCopy;
    }
    /**
     * Set IsCopy value
     * @param bool $isCopy
     * @return \StructType\Document
     */
    public function setIsCopy($isCopy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCopy) && !is_bool($isCopy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCopy, true), gettype($isCopy)), __LINE__);
        }
        $this->IsCopy = $isCopy;
        return $this;
    }
    /**
     * Get CopiedFromID value
     * @return int
     */
    public function getCopiedFromID()
    {
        return $this->CopiedFromID;
    }
    /**
     * Set CopiedFromID value
     * @param int $copiedFromID
     * @return \StructType\Document
     */
    public function setCopiedFromID($copiedFromID = null)
    {
        // validation for constraint: int
        if (!is_null($copiedFromID) && !(is_int($copiedFromID) || ctype_digit($copiedFromID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($copiedFromID, true), gettype($copiedFromID)), __LINE__);
        }
        $this->CopiedFromID = $copiedFromID;
        return $this;
    }
    /**
     * Get IndividualInfoUserID value
     * @return int
     */
    public function getIndividualInfoUserID()
    {
        return $this->IndividualInfoUserID;
    }
    /**
     * Set IndividualInfoUserID value
     * @param int $individualInfoUserID
     * @return \StructType\Document
     */
    public function setIndividualInfoUserID($individualInfoUserID = null)
    {
        // validation for constraint: int
        if (!is_null($individualInfoUserID) && !(is_int($individualInfoUserID) || ctype_digit($individualInfoUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($individualInfoUserID, true), gettype($individualInfoUserID)), __LINE__);
        }
        $this->IndividualInfoUserID = $individualInfoUserID;
        return $this;
    }
    /**
     * Get SendLocation value
     * @return int
     */
    public function getSendLocation()
    {
        return $this->SendLocation;
    }
    /**
     * Set SendLocation value
     * @param int $sendLocation
     * @return \StructType\Document
     */
    public function setSendLocation($sendLocation = null)
    {
        // validation for constraint: int
        if (!is_null($sendLocation) && !(is_int($sendLocation) || ctype_digit($sendLocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sendLocation, true), gettype($sendLocation)), __LINE__);
        }
        $this->SendLocation = $sendLocation;
        return $this;
    }
    /**
     * Get IsPhysical value
     * @return bool
     */
    public function getIsPhysical()
    {
        return $this->IsPhysical;
    }
    /**
     * Set IsPhysical value
     * @param bool $isPhysical
     * @return \StructType\Document
     */
    public function setIsPhysical($isPhysical = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPhysical) && !is_bool($isPhysical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPhysical, true), gettype($isPhysical)), __LINE__);
        }
        $this->IsPhysical = $isPhysical;
        return $this;
    }
    /**
     * Get IsCopyrightContent value
     * @return bool
     */
    public function getIsCopyrightContent()
    {
        return $this->IsCopyrightContent;
    }
    /**
     * Set IsCopyrightContent value
     * @param bool $isCopyrightContent
     * @return \StructType\Document
     */
    public function setIsCopyrightContent($isCopyrightContent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCopyrightContent) && !is_bool($isCopyrightContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCopyrightContent, true), gettype($isCopyrightContent)), __LINE__);
        }
        $this->IsCopyrightContent = $isCopyrightContent;
        return $this;
    }
    /**
     * Get IsPrivateToOwner value
     * @return bool
     */
    public function getIsPrivateToOwner()
    {
        return $this->IsPrivateToOwner;
    }
    /**
     * Set IsPrivateToOwner value
     * @param bool $isPrivateToOwner
     * @return \StructType\Document
     */
    public function setIsPrivateToOwner($isPrivateToOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivateToOwner) && !is_bool($isPrivateToOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrivateToOwner, true), gettype($isPrivateToOwner)), __LINE__);
        }
        $this->IsPrivateToOwner = $isPrivateToOwner;
        return $this;
    }
    /**
     * Get CameLocation value
     * @return int
     */
    public function getCameLocation()
    {
        return $this->CameLocation;
    }
    /**
     * Set CameLocation value
     * @param int $cameLocation
     * @return \StructType\Document
     */
    public function setCameLocation($cameLocation = null)
    {
        // validation for constraint: int
        if (!is_null($cameLocation) && !(is_int($cameLocation) || ctype_digit($cameLocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cameLocation, true), gettype($cameLocation)), __LINE__);
        }
        $this->CameLocation = $cameLocation;
        return $this;
    }
    /**
     * Get IsCameLocation value
     * @return bool
     */
    public function getIsCameLocation()
    {
        return $this->IsCameLocation;
    }
    /**
     * Set IsCameLocation value
     * @param bool $isCameLocation
     * @return \StructType\Document
     */
    public function setIsCameLocation($isCameLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCameLocation) && !is_bool($isCameLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCameLocation, true), gettype($isCameLocation)), __LINE__);
        }
        $this->IsCameLocation = $isCameLocation;
        return $this;
    }
    /**
     * Get EmailID value
     * @return int
     */
    public function getEmailID()
    {
        return $this->EmailID;
    }
    /**
     * Set EmailID value
     * @param int $emailID
     * @return \StructType\Document
     */
    public function setEmailID($emailID = null)
    {
        // validation for constraint: int
        if (!is_null($emailID) && !(is_int($emailID) || ctype_digit($emailID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emailID, true), gettype($emailID)), __LINE__);
        }
        $this->EmailID = $emailID;
        return $this;
    }
    /**
     * Get SignedDocument value
     * @return bool
     */
    public function getSignedDocument()
    {
        return $this->SignedDocument;
    }
    /**
     * Set SignedDocument value
     * @param bool $signedDocument
     * @return \StructType\Document
     */
    public function setSignedDocument($signedDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($signedDocument) && !is_bool($signedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signedDocument, true), gettype($signedDocument)), __LINE__);
        }
        $this->SignedDocument = $signedDocument;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return bool
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param bool $timeStamp
     * @return \StructType\Document
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: boolean
        if (!is_null($timeStamp) && !is_bool($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get CryptionAlgorithm value
     * @return bool
     */
    public function getCryptionAlgorithm()
    {
        return $this->CryptionAlgorithm;
    }
    /**
     * Set CryptionAlgorithm value
     * @param bool $cryptionAlgorithm
     * @return \StructType\Document
     */
    public function setCryptionAlgorithm($cryptionAlgorithm = null)
    {
        // validation for constraint: boolean
        if (!is_null($cryptionAlgorithm) && !is_bool($cryptionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cryptionAlgorithm, true), gettype($cryptionAlgorithm)), __LINE__);
        }
        $this->CryptionAlgorithm = $cryptionAlgorithm;
        return $this;
    }
    /**
     * Get IncomeType value
     * @return int
     */
    public function getIncomeType()
    {
        return $this->IncomeType;
    }
    /**
     * Set IncomeType value
     * @param int $incomeType
     * @return \StructType\Document
     */
    public function setIncomeType($incomeType = null)
    {
        // validation for constraint: int
        if (!is_null($incomeType) && !(is_int($incomeType) || ctype_digit($incomeType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($incomeType, true), gettype($incomeType)), __LINE__);
        }
        $this->IncomeType = $incomeType;
        return $this;
    }
    /**
     * Get OutgoType value
     * @return int
     */
    public function getOutgoType()
    {
        return $this->OutgoType;
    }
    /**
     * Set OutgoType value
     * @param int $outgoType
     * @return \StructType\Document
     */
    public function setOutgoType($outgoType = null)
    {
        // validation for constraint: int
        if (!is_null($outgoType) && !(is_int($outgoType) || ctype_digit($outgoType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outgoType, true), gettype($outgoType)), __LINE__);
        }
        $this->OutgoType = $outgoType;
        return $this;
    }
    /**
     * Get ScopeID value
     * @return int
     */
    public function getScopeID()
    {
        return $this->ScopeID;
    }
    /**
     * Set ScopeID value
     * @param int $scopeID
     * @return \StructType\Document
     */
    public function setScopeID($scopeID = null)
    {
        // validation for constraint: int
        if (!is_null($scopeID) && !(is_int($scopeID) || ctype_digit($scopeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scopeID, true), gettype($scopeID)), __LINE__);
        }
        $this->ScopeID = $scopeID;
        return $this;
    }
    /**
     * Get TemplateID value
     * @return int
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param int $templateID
     * @return \StructType\Document
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !(is_int($templateID) || ctype_digit($templateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateID, true), gettype($templateID)), __LINE__);
        }
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Get DocumentUnitId value
     * @return int
     */
    public function getDocumentUnitId()
    {
        return $this->DocumentUnitId;
    }
    /**
     * Set DocumentUnitId value
     * @param int $documentUnitId
     * @return \StructType\Document
     */
    public function setDocumentUnitId($documentUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($documentUnitId) && !(is_int($documentUnitId) || ctype_digit($documentUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentUnitId, true), gettype($documentUnitId)), __LINE__);
        }
        $this->DocumentUnitId = $documentUnitId;
        return $this;
    }
    /**
     * Get DocumentHash value
     * @return int
     */
    public function getDocumentHash()
    {
        return $this->DocumentHash;
    }
    /**
     * Set DocumentHash value
     * @param int $documentHash
     * @return \StructType\Document
     */
    public function setDocumentHash($documentHash = null)
    {
        // validation for constraint: int
        if (!is_null($documentHash) && !(is_int($documentHash) || ctype_digit($documentHash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentHash, true), gettype($documentHash)), __LINE__);
        }
        $this->DocumentHash = $documentHash;
        return $this;
    }
    /**
     * Get CycleEnded value
     * @return bool
     */
    public function getCycleEnded()
    {
        return $this->CycleEnded;
    }
    /**
     * Set CycleEnded value
     * @param bool $cycleEnded
     * @return \StructType\Document
     */
    public function setCycleEnded($cycleEnded = null)
    {
        // validation for constraint: boolean
        if (!is_null($cycleEnded) && !is_bool($cycleEnded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cycleEnded, true), gettype($cycleEnded)), __LINE__);
        }
        $this->CycleEnded = $cycleEnded;
        return $this;
    }
    /**
     * Get QuickWorkFlowID value
     * @return int
     */
    public function getQuickWorkFlowID()
    {
        return $this->QuickWorkFlowID;
    }
    /**
     * Set QuickWorkFlowID value
     * @param int $quickWorkFlowID
     * @return \StructType\Document
     */
    public function setQuickWorkFlowID($quickWorkFlowID = null)
    {
        // validation for constraint: int
        if (!is_null($quickWorkFlowID) && !(is_int($quickWorkFlowID) || ctype_digit($quickWorkFlowID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quickWorkFlowID, true), gettype($quickWorkFlowID)), __LINE__);
        }
        $this->QuickWorkFlowID = $quickWorkFlowID;
        return $this;
    }
    /**
     * Get IsSigned value
     * @return bool
     */
    public function getIsSigned()
    {
        return $this->IsSigned;
    }
    /**
     * Set IsSigned value
     * @param bool $isSigned
     * @return \StructType\Document
     */
    public function setIsSigned($isSigned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSigned) && !is_bool($isSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSigned, true), gettype($isSigned)), __LINE__);
        }
        $this->IsSigned = $isSigned;
        return $this;
    }
    /**
     * Get SentCheck value
     * @return bool
     */
    public function getSentCheck()
    {
        return $this->SentCheck;
    }
    /**
     * Set SentCheck value
     * @param bool $sentCheck
     * @return \StructType\Document
     */
    public function setSentCheck($sentCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($sentCheck) && !is_bool($sentCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sentCheck, true), gettype($sentCheck)), __LINE__);
        }
        $this->SentCheck = $sentCheck;
        return $this;
    }
    /**
     * Get IsInArchive value
     * @return bool
     */
    public function getIsInArchive()
    {
        return $this->IsInArchive;
    }
    /**
     * Set IsInArchive value
     * @param bool $isInArchive
     * @return \StructType\Document
     */
    public function setIsInArchive($isInArchive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInArchive) && !is_bool($isInArchive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInArchive, true), gettype($isInArchive)), __LINE__);
        }
        $this->IsInArchive = $isInArchive;
        return $this;
    }
    /**
     * Get OwnerArchiveFolderOID value
     * @return int
     */
    public function getOwnerArchiveFolderOID()
    {
        return $this->OwnerArchiveFolderOID;
    }
    /**
     * Set OwnerArchiveFolderOID value
     * @param int $ownerArchiveFolderOID
     * @return \StructType\Document
     */
    public function setOwnerArchiveFolderOID($ownerArchiveFolderOID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerArchiveFolderOID) && !(is_int($ownerArchiveFolderOID) || ctype_digit($ownerArchiveFolderOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerArchiveFolderOID, true), gettype($ownerArchiveFolderOID)), __LINE__);
        }
        $this->OwnerArchiveFolderOID = $ownerArchiveFolderOID;
        return $this;
    }
    /**
     * Get CheckSendLocation value
     * @return bool
     */
    public function getCheckSendLocation()
    {
        return $this->CheckSendLocation;
    }
    /**
     * Set CheckSendLocation value
     * @param bool $checkSendLocation
     * @return \StructType\Document
     */
    public function setCheckSendLocation($checkSendLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkSendLocation) && !is_bool($checkSendLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkSendLocation, true), gettype($checkSendLocation)), __LINE__);
        }
        $this->CheckSendLocation = $checkSendLocation;
        return $this;
    }
    /**
     * Get ImhaKomisyonNo value
     * @return int
     */
    public function getImhaKomisyonNo()
    {
        return $this->ImhaKomisyonNo;
    }
    /**
     * Set ImhaKomisyonNo value
     * @param int $imhaKomisyonNo
     * @return \StructType\Document
     */
    public function setImhaKomisyonNo($imhaKomisyonNo = null)
    {
        // validation for constraint: int
        if (!is_null($imhaKomisyonNo) && !(is_int($imhaKomisyonNo) || ctype_digit($imhaKomisyonNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imhaKomisyonNo, true), gettype($imhaKomisyonNo)), __LINE__);
        }
        $this->ImhaKomisyonNo = $imhaKomisyonNo;
        return $this;
    }
    /**
     * Get HasPassword value
     * @return bool
     */
    public function getHasPassword()
    {
        return $this->HasPassword;
    }
    /**
     * Set HasPassword value
     * @param bool $hasPassword
     * @return \StructType\Document
     */
    public function setHasPassword($hasPassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPassword) && !is_bool($hasPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPassword, true), gettype($hasPassword)), __LINE__);
        }
        $this->HasPassword = $hasPassword;
        return $this;
    }
    /**
     * Get IncomingDocType value
     * @return int
     */
    public function getIncomingDocType()
    {
        return $this->IncomingDocType;
    }
    /**
     * Set IncomingDocType value
     * @param int $incomingDocType
     * @return \StructType\Document
     */
    public function setIncomingDocType($incomingDocType = null)
    {
        // validation for constraint: int
        if (!is_null($incomingDocType) && !(is_int($incomingDocType) || ctype_digit($incomingDocType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($incomingDocType, true), gettype($incomingDocType)), __LINE__);
        }
        $this->IncomingDocType = $incomingDocType;
        return $this;
    }
    /**
     * Get CompleteWFprocess value
     * @return bool
     */
    public function getCompleteWFprocess()
    {
        return $this->CompleteWFprocess;
    }
    /**
     * Set CompleteWFprocess value
     * @param bool $completeWFprocess
     * @return \StructType\Document
     */
    public function setCompleteWFprocess($completeWFprocess = null)
    {
        // validation for constraint: boolean
        if (!is_null($completeWFprocess) && !is_bool($completeWFprocess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($completeWFprocess, true), gettype($completeWFprocess)), __LINE__);
        }
        $this->CompleteWFprocess = $completeWFprocess;
        return $this;
    }
    /**
     * Get IsConfirmation value
     * @return bool
     */
    public function getIsConfirmation()
    {
        return $this->IsConfirmation;
    }
    /**
     * Set IsConfirmation value
     * @param bool $isConfirmation
     * @return \StructType\Document
     */
    public function setIsConfirmation($isConfirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmation) && !is_bool($isConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmation, true), gettype($isConfirmation)), __LINE__);
        }
        $this->IsConfirmation = $isConfirmation;
        return $this;
    }
    /**
     * Get IsOCR value
     * @return bool
     */
    public function getIsOCR()
    {
        return $this->IsOCR;
    }
    /**
     * Set IsOCR value
     * @param bool $isOCR
     * @return \StructType\Document
     */
    public function setIsOCR($isOCR = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOCR) && !is_bool($isOCR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOCR, true), gettype($isOCR)), __LINE__);
        }
        $this->IsOCR = $isOCR;
        return $this;
    }
    /**
     * Get SystemPropertyId value
     * @return int
     */
    public function getSystemPropertyId()
    {
        return $this->SystemPropertyId;
    }
    /**
     * Set SystemPropertyId value
     * @param int $systemPropertyId
     * @return \StructType\Document
     */
    public function setSystemPropertyId($systemPropertyId = null)
    {
        // validation for constraint: int
        if (!is_null($systemPropertyId) && !(is_int($systemPropertyId) || ctype_digit($systemPropertyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemPropertyId, true), gettype($systemPropertyId)), __LINE__);
        }
        $this->SystemPropertyId = $systemPropertyId;
        return $this;
    }
    /**
     * Get TemplateCount value
     * @return int
     */
    public function getTemplateCount()
    {
        return $this->TemplateCount;
    }
    /**
     * Set TemplateCount value
     * @param int $templateCount
     * @return \StructType\Document
     */
    public function setTemplateCount($templateCount = null)
    {
        // validation for constraint: int
        if (!is_null($templateCount) && !(is_int($templateCount) || ctype_digit($templateCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateCount, true), gettype($templateCount)), __LINE__);
        }
        $this->TemplateCount = $templateCount;
        return $this;
    }
    /**
     * Get IsDestroyed value
     * @return bool
     */
    public function getIsDestroyed()
    {
        return $this->IsDestroyed;
    }
    /**
     * Set IsDestroyed value
     * @param bool $isDestroyed
     * @return \StructType\Document
     */
    public function setIsDestroyed($isDestroyed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDestroyed) && !is_bool($isDestroyed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDestroyed, true), gettype($isDestroyed)), __LINE__);
        }
        $this->IsDestroyed = $isDestroyed;
        return $this;
    }
    /**
     * Get IsArchived value
     * @return bool
     */
    public function getIsArchived()
    {
        return $this->IsArchived;
    }
    /**
     * Set IsArchived value
     * @param bool $isArchived
     * @return \StructType\Document
     */
    public function setIsArchived($isArchived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArchived) && !is_bool($isArchived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isArchived, true), gettype($isArchived)), __LINE__);
        }
        $this->IsArchived = $isArchived;
        return $this;
    }
    /**
     * Get DocumentSystemProperty value
     * @return \StructType\SystemProperty|null
     */
    public function getDocumentSystemProperty()
    {
        return $this->DocumentSystemProperty;
    }
    /**
     * Set DocumentSystemProperty value
     * @param \StructType\SystemProperty $documentSystemProperty
     * @return \StructType\Document
     */
    public function setDocumentSystemProperty(\StructType\SystemProperty $documentSystemProperty = null)
    {
        $this->DocumentSystemProperty = $documentSystemProperty;
        return $this;
    }
    /**
     * Get AppendixInfo value
     * @return \ArrayType\ArrayOfAppendix|null
     */
    public function getAppendixInfo()
    {
        return $this->AppendixInfo;
    }
    /**
     * Set AppendixInfo value
     * @param \ArrayType\ArrayOfAppendix $appendixInfo
     * @return \StructType\Document
     */
    public function setAppendixInfo(\ArrayType\ArrayOfAppendix $appendixInfo = null)
    {
        $this->AppendixInfo = $appendixInfo;
        return $this;
    }
    /**
     * Get DistributionlistInfo value
     * @return \ArrayType\ArrayOfDistributionlist|null
     */
    public function getDistributionlistInfo()
    {
        return $this->DistributionlistInfo;
    }
    /**
     * Set DistributionlistInfo value
     * @param \ArrayType\ArrayOfDistributionlist $distributionlistInfo
     * @return \StructType\Document
     */
    public function setDistributionlistInfo(\ArrayType\ArrayOfDistributionlist $distributionlistInfo = null)
    {
        $this->DistributionlistInfo = $distributionlistInfo;
        return $this;
    }
    /**
     * Get ArchiveStoreTypes value
     * @return \ArrayType\ArrayOfArchiveStore|null
     */
    public function getArchiveStoreTypes()
    {
        return $this->ArchiveStoreTypes;
    }
    /**
     * Set ArchiveStoreTypes value
     * @param \ArrayType\ArrayOfArchiveStore $archiveStoreTypes
     * @return \StructType\Document
     */
    public function setArchiveStoreTypes(\ArrayType\ArrayOfArchiveStore $archiveStoreTypes = null)
    {
        $this->ArchiveStoreTypes = $archiveStoreTypes;
        return $this;
    }
    /**
     * Get SecurityLevels value
     * @return \ArrayType\ArrayOfSecurityLevelShortInfo|null
     */
    public function getSecurityLevels()
    {
        return $this->SecurityLevels;
    }
    /**
     * Set SecurityLevels value
     * @param \ArrayType\ArrayOfSecurityLevelShortInfo $securityLevels
     * @return \StructType\Document
     */
    public function setSecurityLevels(\ArrayType\ArrayOfSecurityLevelShortInfo $securityLevels = null)
    {
        $this->SecurityLevels = $securityLevels;
        return $this;
    }
    /**
     * Get DocumentArchiveStore value
     * @return \StructType\ArchiveStore|null
     */
    public function getDocumentArchiveStore()
    {
        return $this->DocumentArchiveStore;
    }
    /**
     * Set DocumentArchiveStore value
     * @param \StructType\ArchiveStore $documentArchiveStore
     * @return \StructType\Document
     */
    public function setDocumentArchiveStore(\StructType\ArchiveStore $documentArchiveStore = null)
    {
        $this->DocumentArchiveStore = $documentArchiveStore;
        return $this;
    }
    /**
     * Get OwnersSerialNumber value
     * @return string|null
     */
    public function getOwnersSerialNumber()
    {
        return $this->OwnersSerialNumber;
    }
    /**
     * Set OwnersSerialNumber value
     * @param string $ownersSerialNumber
     * @return \StructType\Document
     */
    public function setOwnersSerialNumber($ownersSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ownersSerialNumber) && !is_string($ownersSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersSerialNumber, true), gettype($ownersSerialNumber)), __LINE__);
        }
        $this->OwnersSerialNumber = $ownersSerialNumber;
        return $this;
    }
    /**
     * Get PostedFileName value
     * @return string|null
     */
    public function getPostedFileName()
    {
        return $this->PostedFileName;
    }
    /**
     * Set PostedFileName value
     * @param string $postedFileName
     * @return \StructType\Document
     */
    public function setPostedFileName($postedFileName = null)
    {
        // validation for constraint: string
        if (!is_null($postedFileName) && !is_string($postedFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postedFileName, true), gettype($postedFileName)), __LINE__);
        }
        $this->PostedFileName = $postedFileName;
        return $this;
    }
    /**
     * Get ScannedProperties value
     * @return \StructType\ScannedImageProperties|null
     */
    public function getScannedProperties()
    {
        return $this->ScannedProperties;
    }
    /**
     * Set ScannedProperties value
     * @param \StructType\ScannedImageProperties $scannedProperties
     * @return \StructType\Document
     */
    public function setScannedProperties(\StructType\ScannedImageProperties $scannedProperties = null)
    {
        $this->ScannedProperties = $scannedProperties;
        return $this;
    }
    /**
     * Get DocumentTopic value
     * @return string|null
     */
    public function getDocumentTopic()
    {
        return $this->DocumentTopic;
    }
    /**
     * Set DocumentTopic value
     * @param string $documentTopic
     * @return \StructType\Document
     */
    public function setDocumentTopic($documentTopic = null)
    {
        // validation for constraint: string
        if (!is_null($documentTopic) && !is_string($documentTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTopic, true), gettype($documentTopic)), __LINE__);
        }
        $this->DocumentTopic = $documentTopic;
        return $this;
    }
    /**
     * Get DocumentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->DocumentName;
    }
    /**
     * Set DocumentName value
     * @param string $documentName
     * @return \StructType\Document
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        $this->DocumentName = $documentName;
        return $this;
    }
    /**
     * Get DocumentOwner value
     * @return string|null
     */
    public function getDocumentOwner()
    {
        return $this->DocumentOwner;
    }
    /**
     * Set DocumentOwner value
     * @param string $documentOwner
     * @return \StructType\Document
     */
    public function setDocumentOwner($documentOwner = null)
    {
        // validation for constraint: string
        if (!is_null($documentOwner) && !is_string($documentOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentOwner, true), gettype($documentOwner)), __LINE__);
        }
        $this->DocumentOwner = $documentOwner;
        return $this;
    }
    /**
     * Get DocumentUnit value
     * @return string|null
     */
    public function getDocumentUnit()
    {
        return $this->DocumentUnit;
    }
    /**
     * Set DocumentUnit value
     * @param string $documentUnit
     * @return \StructType\Document
     */
    public function setDocumentUnit($documentUnit = null)
    {
        // validation for constraint: string
        if (!is_null($documentUnit) && !is_string($documentUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentUnit, true), gettype($documentUnit)), __LINE__);
        }
        $this->DocumentUnit = $documentUnit;
        return $this;
    }
    /**
     * Get DocumentPlanNo value
     * @return string|null
     */
    public function getDocumentPlanNo()
    {
        return $this->DocumentPlanNo;
    }
    /**
     * Set DocumentPlanNo value
     * @param string $documentPlanNo
     * @return \StructType\Document
     */
    public function setDocumentPlanNo($documentPlanNo = null)
    {
        // validation for constraint: string
        if (!is_null($documentPlanNo) && !is_string($documentPlanNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentPlanNo, true), gettype($documentPlanNo)), __LINE__);
        }
        $this->DocumentPlanNo = $documentPlanNo;
        return $this;
    }
    /**
     * Get DocumentDescription value
     * @return string|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }
    /**
     * Set DocumentDescription value
     * @param string $documentDescription
     * @return \StructType\Document
     */
    public function setDocumentDescription($documentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($documentDescription) && !is_string($documentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDescription, true), gettype($documentDescription)), __LINE__);
        }
        $this->DocumentDescription = $documentDescription;
        return $this;
    }
    /**
     * Get CancellationReason value
     * @return string|null
     */
    public function getCancellationReason()
    {
        return $this->CancellationReason;
    }
    /**
     * Set CancellationReason value
     * @param string $cancellationReason
     * @return \StructType\Document
     */
    public function setCancellationReason($cancellationReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationReason) && !is_string($cancellationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationReason, true), gettype($cancellationReason)), __LINE__);
        }
        $this->CancellationReason = $cancellationReason;
        return $this;
    }
    /**
     * Get PhysicalDocumentPath value
     * @return string|null
     */
    public function getPhysicalDocumentPath()
    {
        return $this->PhysicalDocumentPath;
    }
    /**
     * Set PhysicalDocumentPath value
     * @param string $physicalDocumentPath
     * @return \StructType\Document
     */
    public function setPhysicalDocumentPath($physicalDocumentPath = null)
    {
        // validation for constraint: string
        if (!is_null($physicalDocumentPath) && !is_string($physicalDocumentPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalDocumentPath, true), gettype($physicalDocumentPath)), __LINE__);
        }
        $this->PhysicalDocumentPath = $physicalDocumentPath;
        return $this;
    }
    /**
     * Get DocumentKeywords value
     * @return string|null
     */
    public function getDocumentKeywords()
    {
        return $this->DocumentKeywords;
    }
    /**
     * Set DocumentKeywords value
     * @param string $documentKeywords
     * @return \StructType\Document
     */
    public function setDocumentKeywords($documentKeywords = null)
    {
        // validation for constraint: string
        if (!is_null($documentKeywords) && !is_string($documentKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentKeywords, true), gettype($documentKeywords)), __LINE__);
        }
        $this->DocumentKeywords = $documentKeywords;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \StructType\Document
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentNo value
     * @return string|null
     */
    public function getDocumentNo()
    {
        return $this->DocumentNo;
    }
    /**
     * Set DocumentNo value
     * @param string $documentNo
     * @return \StructType\Document
     */
    public function setDocumentNo($documentNo = null)
    {
        // validation for constraint: string
        if (!is_null($documentNo) && !is_string($documentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNo, true), gettype($documentNo)), __LINE__);
        }
        $this->DocumentNo = $documentNo;
        return $this;
    }
    /**
     * Get SendLocationName value
     * @return string|null
     */
    public function getSendLocationName()
    {
        return $this->SendLocationName;
    }
    /**
     * Set SendLocationName value
     * @param string $sendLocationName
     * @return \StructType\Document
     */
    public function setSendLocationName($sendLocationName = null)
    {
        // validation for constraint: string
        if (!is_null($sendLocationName) && !is_string($sendLocationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendLocationName, true), gettype($sendLocationName)), __LINE__);
        }
        $this->SendLocationName = $sendLocationName;
        return $this;
    }
    /**
     * Get CameLocationName value
     * @return string|null
     */
    public function getCameLocationName()
    {
        return $this->CameLocationName;
    }
    /**
     * Set CameLocationName value
     * @param string $cameLocationName
     * @return \StructType\Document
     */
    public function setCameLocationName($cameLocationName = null)
    {
        // validation for constraint: string
        if (!is_null($cameLocationName) && !is_string($cameLocationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cameLocationName, true), gettype($cameLocationName)), __LINE__);
        }
        $this->CameLocationName = $cameLocationName;
        return $this;
    }
    /**
     * Get IndividualInfoUserName value
     * @return string|null
     */
    public function getIndividualInfoUserName()
    {
        return $this->IndividualInfoUserName;
    }
    /**
     * Set IndividualInfoUserName value
     * @param string $individualInfoUserName
     * @return \StructType\Document
     */
    public function setIndividualInfoUserName($individualInfoUserName = null)
    {
        // validation for constraint: string
        if (!is_null($individualInfoUserName) && !is_string($individualInfoUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualInfoUserName, true), gettype($individualInfoUserName)), __LINE__);
        }
        $this->IndividualInfoUserName = $individualInfoUserName;
        return $this;
    }
    /**
     * Get OwnerUserName value
     * @return string|null
     */
    public function getOwnerUserName()
    {
        return $this->OwnerUserName;
    }
    /**
     * Set OwnerUserName value
     * @param string $ownerUserName
     * @return \StructType\Document
     */
    public function setOwnerUserName($ownerUserName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerUserName) && !is_string($ownerUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerUserName, true), gettype($ownerUserName)), __LINE__);
        }
        $this->OwnerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get UploadedFileName value
     * @return string|null
     */
    public function getUploadedFileName()
    {
        return $this->UploadedFileName;
    }
    /**
     * Set UploadedFileName value
     * @param string $uploadedFileName
     * @return \StructType\Document
     */
    public function setUploadedFileName($uploadedFileName = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedFileName) && !is_string($uploadedFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedFileName, true), gettype($uploadedFileName)), __LINE__);
        }
        $this->UploadedFileName = $uploadedFileName;
        return $this;
    }
    /**
     * Get ArchiveFormat value
     * @return string|null
     */
    public function getArchiveFormat()
    {
        return $this->ArchiveFormat;
    }
    /**
     * Set ArchiveFormat value
     * @param string $archiveFormat
     * @return \StructType\Document
     */
    public function setArchiveFormat($archiveFormat = null)
    {
        // validation for constraint: string
        if (!is_null($archiveFormat) && !is_string($archiveFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveFormat, true), gettype($archiveFormat)), __LINE__);
        }
        $this->ArchiveFormat = $archiveFormat;
        return $this;
    }
    /**
     * Get DigitalSigns value
     * @return string|null
     */
    public function getDigitalSigns()
    {
        return $this->DigitalSigns;
    }
    /**
     * Set DigitalSigns value
     * @param string $digitalSigns
     * @return \StructType\Document
     */
    public function setDigitalSigns($digitalSigns = null)
    {
        // validation for constraint: string
        if (!is_null($digitalSigns) && !is_string($digitalSigns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digitalSigns, true), gettype($digitalSigns)), __LINE__);
        }
        $this->DigitalSigns = $digitalSigns;
        return $this;
    }
    /**
     * Get DocumentEntranceDate value
     * @return string|null
     */
    public function getDocumentEntranceDate()
    {
        return $this->DocumentEntranceDate;
    }
    /**
     * Set DocumentEntranceDate value
     * @param string $documentEntranceDate
     * @return \StructType\Document
     */
    public function setDocumentEntranceDate($documentEntranceDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentEntranceDate) && !is_string($documentEntranceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentEntranceDate, true), gettype($documentEntranceDate)), __LINE__);
        }
        $this->DocumentEntranceDate = $documentEntranceDate;
        return $this;
    }
    /**
     * Get DocumentEntranceTime value
     * @return string|null
     */
    public function getDocumentEntranceTime()
    {
        return $this->DocumentEntranceTime;
    }
    /**
     * Set DocumentEntranceTime value
     * @param string $documentEntranceTime
     * @return \StructType\Document
     */
    public function setDocumentEntranceTime($documentEntranceTime = null)
    {
        // validation for constraint: string
        if (!is_null($documentEntranceTime) && !is_string($documentEntranceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentEntranceTime, true), gettype($documentEntranceTime)), __LINE__);
        }
        $this->DocumentEntranceTime = $documentEntranceTime;
        return $this;
    }
    /**
     * Get CameDate value
     * @return string|null
     */
    public function getCameDate()
    {
        return $this->CameDate;
    }
    /**
     * Set CameDate value
     * @param string $cameDate
     * @return \StructType\Document
     */
    public function setCameDate($cameDate = null)
    {
        // validation for constraint: string
        if (!is_null($cameDate) && !is_string($cameDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cameDate, true), gettype($cameDate)), __LINE__);
        }
        $this->CameDate = $cameDate;
        return $this;
    }
    /**
     * Get CameNumber value
     * @return string|null
     */
    public function getCameNumber()
    {
        return $this->CameNumber;
    }
    /**
     * Set CameNumber value
     * @param string $cameNumber
     * @return \StructType\Document
     */
    public function setCameNumber($cameNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cameNumber) && !is_string($cameNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cameNumber, true), gettype($cameNumber)), __LINE__);
        }
        $this->CameNumber = $cameNumber;
        return $this;
    }
    /**
     * Get ESHS value
     * @return string|null
     */
    public function getESHS()
    {
        return $this->ESHS;
    }
    /**
     * Set ESHS value
     * @param string $eSHS
     * @return \StructType\Document
     */
    public function setESHS($eSHS = null)
    {
        // validation for constraint: string
        if (!is_null($eSHS) && !is_string($eSHS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eSHS, true), gettype($eSHS)), __LINE__);
        }
        $this->ESHS = $eSHS;
        return $this;
    }
    /**
     * Get MailDate value
     * @return string|null
     */
    public function getMailDate()
    {
        return $this->MailDate;
    }
    /**
     * Set MailDate value
     * @param string $mailDate
     * @return \StructType\Document
     */
    public function setMailDate($mailDate = null)
    {
        // validation for constraint: string
        if (!is_null($mailDate) && !is_string($mailDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailDate, true), gettype($mailDate)), __LINE__);
        }
        $this->MailDate = $mailDate;
        return $this;
    }
    /**
     * Get ScopeIDText value
     * @return string|null
     */
    public function getScopeIDText()
    {
        return $this->ScopeIDText;
    }
    /**
     * Set ScopeIDText value
     * @param string $scopeIDText
     * @return \StructType\Document
     */
    public function setScopeIDText($scopeIDText = null)
    {
        // validation for constraint: string
        if (!is_null($scopeIDText) && !is_string($scopeIDText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scopeIDText, true), gettype($scopeIDText)), __LINE__);
        }
        $this->ScopeIDText = $scopeIDText;
        return $this;
    }
    /**
     * Get DocumentWriterUnit value
     * @return string|null
     */
    public function getDocumentWriterUnit()
    {
        return $this->DocumentWriterUnit;
    }
    /**
     * Set DocumentWriterUnit value
     * @param string $documentWriterUnit
     * @return \StructType\Document
     */
    public function setDocumentWriterUnit($documentWriterUnit = null)
    {
        // validation for constraint: string
        if (!is_null($documentWriterUnit) && !is_string($documentWriterUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentWriterUnit, true), gettype($documentWriterUnit)), __LINE__);
        }
        $this->DocumentWriterUnit = $documentWriterUnit;
        return $this;
    }
    /**
     * Get ContentText value
     * @return string|null
     */
    public function getContentText()
    {
        return $this->ContentText;
    }
    /**
     * Set ContentText value
     * @param string $contentText
     * @return \StructType\Document
     */
    public function setContentText($contentText = null)
    {
        // validation for constraint: string
        if (!is_null($contentText) && !is_string($contentText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentText, true), gettype($contentText)), __LINE__);
        }
        $this->ContentText = $contentText;
        return $this;
    }
    /**
     * Get DeliveredPerson value
     * @return string|null
     */
    public function getDeliveredPerson()
    {
        return $this->DeliveredPerson;
    }
    /**
     * Set DeliveredPerson value
     * @param string $deliveredPerson
     * @return \StructType\Document
     */
    public function setDeliveredPerson($deliveredPerson = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredPerson) && !is_string($deliveredPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveredPerson, true), gettype($deliveredPerson)), __LINE__);
        }
        $this->DeliveredPerson = $deliveredPerson;
        return $this;
    }
    /**
     * Get SendedDocumentDeliveredPerson value
     * @return string|null
     */
    public function getSendedDocumentDeliveredPerson()
    {
        return $this->SendedDocumentDeliveredPerson;
    }
    /**
     * Set SendedDocumentDeliveredPerson value
     * @param string $sendedDocumentDeliveredPerson
     * @return \StructType\Document
     */
    public function setSendedDocumentDeliveredPerson($sendedDocumentDeliveredPerson = null)
    {
        // validation for constraint: string
        if (!is_null($sendedDocumentDeliveredPerson) && !is_string($sendedDocumentDeliveredPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendedDocumentDeliveredPerson, true), gettype($sendedDocumentDeliveredPerson)), __LINE__);
        }
        $this->SendedDocumentDeliveredPerson = $sendedDocumentDeliveredPerson;
        return $this;
    }
    /**
     * Get AppendixText value
     * @return string|null
     */
    public function getAppendixText()
    {
        return $this->AppendixText;
    }
    /**
     * Set AppendixText value
     * @param string $appendixText
     * @return \StructType\Document
     */
    public function setAppendixText($appendixText = null)
    {
        // validation for constraint: string
        if (!is_null($appendixText) && !is_string($appendixText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appendixText, true), gettype($appendixText)), __LINE__);
        }
        $this->AppendixText = $appendixText;
        return $this;
    }
    /**
     * Get RelatedText value
     * @return string|null
     */
    public function getRelatedText()
    {
        return $this->RelatedText;
    }
    /**
     * Set RelatedText value
     * @param string $relatedText
     * @return \StructType\Document
     */
    public function setRelatedText($relatedText = null)
    {
        // validation for constraint: string
        if (!is_null($relatedText) && !is_string($relatedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedText, true), gettype($relatedText)), __LINE__);
        }
        $this->RelatedText = $relatedText;
        return $this;
    }
    /**
     * Get ConfirmationCode value
     * @return string|null
     */
    public function getConfirmationCode()
    {
        return $this->ConfirmationCode;
    }
    /**
     * Set ConfirmationCode value
     * @param string $confirmationCode
     * @return \StructType\Document
     */
    public function setConfirmationCode($confirmationCode = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationCode) && !is_string($confirmationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationCode, true), gettype($confirmationCode)), __LINE__);
        }
        $this->ConfirmationCode = $confirmationCode;
        return $this;
    }
    /**
     * Get PhysicalFileName value
     * @return string|null
     */
    public function getPhysicalFileName()
    {
        return $this->PhysicalFileName;
    }
    /**
     * Set PhysicalFileName value
     * @param string $physicalFileName
     * @return \StructType\Document
     */
    public function setPhysicalFileName($physicalFileName = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFileName) && !is_string($physicalFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFileName, true), gettype($physicalFileName)), __LINE__);
        }
        $this->PhysicalFileName = $physicalFileName;
        return $this;
    }
    /**
     * Get FileChangedDate value
     * @return string|null
     */
    public function getFileChangedDate()
    {
        return $this->FileChangedDate;
    }
    /**
     * Set FileChangedDate value
     * @param string $fileChangedDate
     * @return \StructType\Document
     */
    public function setFileChangedDate($fileChangedDate = null)
    {
        // validation for constraint: string
        if (!is_null($fileChangedDate) && !is_string($fileChangedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileChangedDate, true), gettype($fileChangedDate)), __LINE__);
        }
        $this->FileChangedDate = $fileChangedDate;
        return $this;
    }
    /**
     * Get DocumentNote value
     * @return string|null
     */
    public function getDocumentNote()
    {
        return $this->DocumentNote;
    }
    /**
     * Set DocumentNote value
     * @param string $documentNote
     * @return \StructType\Document
     */
    public function setDocumentNote($documentNote = null)
    {
        // validation for constraint: string
        if (!is_null($documentNote) && !is_string($documentNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNote, true), gettype($documentNote)), __LINE__);
        }
        $this->DocumentNote = $documentNote;
        return $this;
    }
    /**
     * Get RejectedChange value
     * @return string|null
     */
    public function getRejectedChange()
    {
        return $this->RejectedChange;
    }
    /**
     * Set RejectedChange value
     * @param string $rejectedChange
     * @return \StructType\Document
     */
    public function setRejectedChange($rejectedChange = null)
    {
        // validation for constraint: string
        if (!is_null($rejectedChange) && !is_string($rejectedChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectedChange, true), gettype($rejectedChange)), __LINE__);
        }
        $this->RejectedChange = $rejectedChange;
        return $this;
    }
    /**
     * Get ArchiveEntranceDate value
     * @return string|null
     */
    public function getArchiveEntranceDate()
    {
        return $this->ArchiveEntranceDate;
    }
    /**
     * Set ArchiveEntranceDate value
     * @param string $archiveEntranceDate
     * @return \StructType\Document
     */
    public function setArchiveEntranceDate($archiveEntranceDate = null)
    {
        // validation for constraint: string
        if (!is_null($archiveEntranceDate) && !is_string($archiveEntranceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveEntranceDate, true), gettype($archiveEntranceDate)), __LINE__);
        }
        $this->ArchiveEntranceDate = $archiveEntranceDate;
        return $this;
    }
    /**
     * Get DocumentPassword value
     * @return string|null
     */
    public function getDocumentPassword()
    {
        return $this->DocumentPassword;
    }
    /**
     * Set DocumentPassword value
     * @param string $documentPassword
     * @return \StructType\Document
     */
    public function setDocumentPassword($documentPassword = null)
    {
        // validation for constraint: string
        if (!is_null($documentPassword) && !is_string($documentPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentPassword, true), gettype($documentPassword)), __LINE__);
        }
        $this->DocumentPassword = $documentPassword;
        return $this;
    }
    /**
     * Get LockerUserName value
     * @return string|null
     */
    public function getLockerUserName()
    {
        return $this->LockerUserName;
    }
    /**
     * Set LockerUserName value
     * @param string $lockerUserName
     * @return \StructType\Document
     */
    public function setLockerUserName($lockerUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lockerUserName) && !is_string($lockerUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockerUserName, true), gettype($lockerUserName)), __LINE__);
        }
        $this->LockerUserName = $lockerUserName;
        return $this;
    }
    /**
     * Get IncomingDocSenderTCNumber value
     * @return string|null
     */
    public function getIncomingDocSenderTCNumber()
    {
        return $this->IncomingDocSenderTCNumber;
    }
    /**
     * Set IncomingDocSenderTCNumber value
     * @param string $incomingDocSenderTCNumber
     * @return \StructType\Document
     */
    public function setIncomingDocSenderTCNumber($incomingDocSenderTCNumber = null)
    {
        // validation for constraint: string
        if (!is_null($incomingDocSenderTCNumber) && !is_string($incomingDocSenderTCNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomingDocSenderTCNumber, true), gettype($incomingDocSenderTCNumber)), __LINE__);
        }
        $this->IncomingDocSenderTCNumber = $incomingDocSenderTCNumber;
        return $this;
    }
    /**
     * Get DistributionEditor value
     * @return string|null
     */
    public function getDistributionEditor()
    {
        return $this->DistributionEditor;
    }
    /**
     * Set DistributionEditor value
     * @param string $distributionEditor
     * @return \StructType\Document
     */
    public function setDistributionEditor($distributionEditor = null)
    {
        // validation for constraint: string
        if (!is_null($distributionEditor) && !is_string($distributionEditor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionEditor, true), gettype($distributionEditor)), __LINE__);
        }
        $this->DistributionEditor = $distributionEditor;
        return $this;
    }
    /**
     * Get ExtraItem value
     * @return string|null
     */
    public function getExtraItem()
    {
        return $this->ExtraItem;
    }
    /**
     * Set ExtraItem value
     * @param string $extraItem
     * @return \StructType\Document
     */
    public function setExtraItem($extraItem = null)
    {
        // validation for constraint: string
        if (!is_null($extraItem) && !is_string($extraItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraItem, true), gettype($extraItem)), __LINE__);
        }
        $this->ExtraItem = $extraItem;
        return $this;
    }
    /**
     * Get TemplateCountMontly value
     * @return string|null
     */
    public function getTemplateCountMontly()
    {
        return $this->TemplateCountMontly;
    }
    /**
     * Set TemplateCountMontly value
     * @param string $templateCountMontly
     * @return \StructType\Document
     */
    public function setTemplateCountMontly($templateCountMontly = null)
    {
        // validation for constraint: string
        if (!is_null($templateCountMontly) && !is_string($templateCountMontly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateCountMontly, true), gettype($templateCountMontly)), __LINE__);
        }
        $this->TemplateCountMontly = $templateCountMontly;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \StructType\Document
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\Document
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get PublishStatus value
     * @return string|null
     */
    public function getPublishStatus()
    {
        return $this->PublishStatus;
    }
    /**
     * Set PublishStatus value
     * @param string $publishStatus
     * @return \StructType\Document
     */
    public function setPublishStatus($publishStatus = null)
    {
        // validation for constraint: string
        if (!is_null($publishStatus) && !is_string($publishStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishStatus, true), gettype($publishStatus)), __LINE__);
        }
        $this->PublishStatus = $publishStatus;
        return $this;
    }
}
