<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for JMOBIST ServiceType
 * @subpackage Services
 */
class JMOBIST extends AbstractSoapClientBase
{
    /**
     * Sets the AuthCredential SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthCredential $authCredential
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthCredential(\StructType\AuthCredential $authCredential, $nameSpace = 'http://ebys.bivent.com.tr/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthCredential', $authCredential, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named JMOBISToEbysBelgeSorgula
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\JMOBISToEbysBelgeSorgula $parameters
     * @return \StructType\JMOBISToEbysBelgeSorgulaResponse|bool
     */
    public function JMOBISToEbysBelgeSorgula(\StructType\JMOBISToEbysBelgeSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->JMOBISToEbysBelgeSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named JMOBISToEbysBelgeOlustur
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\JMOBISToEbysBelgeOlustur $parameters
     * @return \StructType\JMOBISToEbysBelgeOlusturResponse|bool
     */
    public function JMOBISToEbysBelgeOlustur(\StructType\JMOBISToEbysBelgeOlustur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->JMOBISToEbysBelgeOlustur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\JMOBISToEbysBelgeOlusturResponse|\StructType\JMOBISToEbysBelgeSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
