<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSimpleObject ArrayType
 * @subpackage Arrays
 */
class ArrayOfSimpleObject extends AbstractStructArrayBase
{
    /**
     * The SimpleObject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SimpleObject[]
     */
    public $SimpleObject;
    /**
     * Constructor method for ArrayOfSimpleObject
     * @uses ArrayOfSimpleObject::setSimpleObject()
     * @param \StructType\SimpleObject[] $simpleObject
     */
    public function __construct(array $simpleObject = array())
    {
        $this
            ->setSimpleObject($simpleObject);
    }
    /**
     * Get SimpleObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SimpleObject[]|null
     */
    public function getSimpleObject()
    {
        return isset($this->SimpleObject) ? $this->SimpleObject : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSimpleObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSimpleObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSimpleObjectForArrayConstraintsFromSetSimpleObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSimpleObjectSimpleObjectItem) {
            // validation for constraint: itemType
            if (!$arrayOfSimpleObjectSimpleObjectItem instanceof \StructType\SimpleObject) {
                $invalidValues[] = is_object($arrayOfSimpleObjectSimpleObjectItem) ? get_class($arrayOfSimpleObjectSimpleObjectItem) : sprintf('%s(%s)', gettype($arrayOfSimpleObjectSimpleObjectItem), var_export($arrayOfSimpleObjectSimpleObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SimpleObject property can only contain items of type \StructType\SimpleObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SimpleObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SimpleObject[] $simpleObject
     * @return \ArrayType\ArrayOfSimpleObject
     */
    public function setSimpleObject(array $simpleObject = array())
    {
        // validation for constraint: array
        if ('' !== ($simpleObjectArrayErrorMessage = self::validateSimpleObjectForArrayConstraintsFromSetSimpleObject($simpleObject))) {
            throw new \InvalidArgumentException($simpleObjectArrayErrorMessage, __LINE__);
        }
        if (is_null($simpleObject) || (is_array($simpleObject) && empty($simpleObject))) {
            unset($this->SimpleObject);
        } else {
            $this->SimpleObject = $simpleObject;
        }
        return $this;
    }
    /**
     * Add item to SimpleObject value
     * @throws \InvalidArgumentException
     * @param \StructType\SimpleObject $item
     * @return \ArrayType\ArrayOfSimpleObject
     */
    public function addToSimpleObject(\StructType\SimpleObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SimpleObject) {
            throw new \InvalidArgumentException(sprintf('The SimpleObject property can only contain items of type \StructType\SimpleObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SimpleObject[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SimpleObject|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SimpleObject|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SimpleObject|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SimpleObject|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SimpleObject|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SimpleObject
     */
    public function getAttributeName()
    {
        return 'SimpleObject';
    }
}
