<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceUserInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfServiceUserInfo extends AbstractStructArrayBase
{
    /**
     * The ServiceUserInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceUserInfo[]
     */
    public $ServiceUserInfo;
    /**
     * Constructor method for ArrayOfServiceUserInfo
     * @uses ArrayOfServiceUserInfo::setServiceUserInfo()
     * @param \StructType\ServiceUserInfo[] $serviceUserInfo
     */
    public function __construct(array $serviceUserInfo = array())
    {
        $this
            ->setServiceUserInfo($serviceUserInfo);
    }
    /**
     * Get ServiceUserInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceUserInfo[]|null
     */
    public function getServiceUserInfo()
    {
        return isset($this->ServiceUserInfo) ? $this->ServiceUserInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceUserInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceUserInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceUserInfoForArrayConstraintsFromSetServiceUserInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceUserInfoServiceUserInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceUserInfoServiceUserInfoItem instanceof \StructType\ServiceUserInfo) {
                $invalidValues[] = is_object($arrayOfServiceUserInfoServiceUserInfoItem) ? get_class($arrayOfServiceUserInfoServiceUserInfoItem) : sprintf('%s(%s)', gettype($arrayOfServiceUserInfoServiceUserInfoItem), var_export($arrayOfServiceUserInfoServiceUserInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceUserInfo property can only contain items of type \StructType\ServiceUserInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceUserInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceUserInfo[] $serviceUserInfo
     * @return \ArrayType\ArrayOfServiceUserInfo
     */
    public function setServiceUserInfo(array $serviceUserInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceUserInfoArrayErrorMessage = self::validateServiceUserInfoForArrayConstraintsFromSetServiceUserInfo($serviceUserInfo))) {
            throw new \InvalidArgumentException($serviceUserInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceUserInfo) || (is_array($serviceUserInfo) && empty($serviceUserInfo))) {
            unset($this->ServiceUserInfo);
        } else {
            $this->ServiceUserInfo = $serviceUserInfo;
        }
        return $this;
    }
    /**
     * Add item to ServiceUserInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceUserInfo $item
     * @return \ArrayType\ArrayOfServiceUserInfo
     */
    public function addToServiceUserInfo(\StructType\ServiceUserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceUserInfo) {
            throw new \InvalidArgumentException(sprintf('The ServiceUserInfo property can only contain items of type \StructType\ServiceUserInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceUserInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceUserInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceUserInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceUserInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceUserInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceUserInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceUserInfo
     */
    public function getAttributeName()
    {
        return 'ServiceUserInfo';
    }
}
