<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentTypeProfileValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentTypeProfileValue extends AbstractStructArrayBase
{
    /**
     * The DocumentTypeProfileValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentTypeProfileValue[]
     */
    public $DocumentTypeProfileValue;
    /**
     * Constructor method for ArrayOfDocumentTypeProfileValue
     * @uses ArrayOfDocumentTypeProfileValue::setDocumentTypeProfileValue()
     * @param \StructType\DocumentTypeProfileValue[] $documentTypeProfileValue
     */
    public function __construct(array $documentTypeProfileValue = array())
    {
        $this
            ->setDocumentTypeProfileValue($documentTypeProfileValue);
    }
    /**
     * Get DocumentTypeProfileValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentTypeProfileValue[]|null
     */
    public function getDocumentTypeProfileValue()
    {
        return isset($this->DocumentTypeProfileValue) ? $this->DocumentTypeProfileValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentTypeProfileValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentTypeProfileValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentTypeProfileValueForArrayConstraintsFromSetDocumentTypeProfileValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentTypeProfileValueDocumentTypeProfileValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentTypeProfileValueDocumentTypeProfileValueItem instanceof \StructType\DocumentTypeProfileValue) {
                $invalidValues[] = is_object($arrayOfDocumentTypeProfileValueDocumentTypeProfileValueItem) ? get_class($arrayOfDocumentTypeProfileValueDocumentTypeProfileValueItem) : sprintf('%s(%s)', gettype($arrayOfDocumentTypeProfileValueDocumentTypeProfileValueItem), var_export($arrayOfDocumentTypeProfileValueDocumentTypeProfileValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentTypeProfileValue property can only contain items of type \StructType\DocumentTypeProfileValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentTypeProfileValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentTypeProfileValue[] $documentTypeProfileValue
     * @return \ArrayType\ArrayOfDocumentTypeProfileValue
     */
    public function setDocumentTypeProfileValue(array $documentTypeProfileValue = array())
    {
        // validation for constraint: array
        if ('' !== ($documentTypeProfileValueArrayErrorMessage = self::validateDocumentTypeProfileValueForArrayConstraintsFromSetDocumentTypeProfileValue($documentTypeProfileValue))) {
            throw new \InvalidArgumentException($documentTypeProfileValueArrayErrorMessage, __LINE__);
        }
        if (is_null($documentTypeProfileValue) || (is_array($documentTypeProfileValue) && empty($documentTypeProfileValue))) {
            unset($this->DocumentTypeProfileValue);
        } else {
            $this->DocumentTypeProfileValue = $documentTypeProfileValue;
        }
        return $this;
    }
    /**
     * Add item to DocumentTypeProfileValue value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentTypeProfileValue $item
     * @return \ArrayType\ArrayOfDocumentTypeProfileValue
     */
    public function addToDocumentTypeProfileValue(\StructType\DocumentTypeProfileValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentTypeProfileValue) {
            throw new \InvalidArgumentException(sprintf('The DocumentTypeProfileValue property can only contain items of type \StructType\DocumentTypeProfileValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentTypeProfileValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentTypeProfileValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentTypeProfileValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentTypeProfileValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentTypeProfileValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentTypeProfileValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentTypeProfileValue
     */
    public function getAttributeName()
    {
        return 'DocumentTypeProfileValue';
    }
}
