<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArchiveStore ArrayType
 * @subpackage Arrays
 */
class ArrayOfArchiveStore extends AbstractStructArrayBase
{
    /**
     * The ArchiveStore
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArchiveStore[]
     */
    public $ArchiveStore;
    /**
     * Constructor method for ArrayOfArchiveStore
     * @uses ArrayOfArchiveStore::setArchiveStore()
     * @param \StructType\ArchiveStore[] $archiveStore
     */
    public function __construct(array $archiveStore = array())
    {
        $this
            ->setArchiveStore($archiveStore);
    }
    /**
     * Get ArchiveStore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArchiveStore[]|null
     */
    public function getArchiveStore()
    {
        return isset($this->ArchiveStore) ? $this->ArchiveStore : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArchiveStore method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArchiveStore method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArchiveStoreForArrayConstraintsFromSetArchiveStore(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArchiveStoreArchiveStoreItem) {
            // validation for constraint: itemType
            if (!$arrayOfArchiveStoreArchiveStoreItem instanceof \StructType\ArchiveStore) {
                $invalidValues[] = is_object($arrayOfArchiveStoreArchiveStoreItem) ? get_class($arrayOfArchiveStoreArchiveStoreItem) : sprintf('%s(%s)', gettype($arrayOfArchiveStoreArchiveStoreItem), var_export($arrayOfArchiveStoreArchiveStoreItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArchiveStore property can only contain items of type \StructType\ArchiveStore, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArchiveStore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArchiveStore[] $archiveStore
     * @return \ArrayType\ArrayOfArchiveStore
     */
    public function setArchiveStore(array $archiveStore = array())
    {
        // validation for constraint: array
        if ('' !== ($archiveStoreArrayErrorMessage = self::validateArchiveStoreForArrayConstraintsFromSetArchiveStore($archiveStore))) {
            throw new \InvalidArgumentException($archiveStoreArrayErrorMessage, __LINE__);
        }
        if (is_null($archiveStore) || (is_array($archiveStore) && empty($archiveStore))) {
            unset($this->ArchiveStore);
        } else {
            $this->ArchiveStore = $archiveStore;
        }
        return $this;
    }
    /**
     * Add item to ArchiveStore value
     * @throws \InvalidArgumentException
     * @param \StructType\ArchiveStore $item
     * @return \ArrayType\ArrayOfArchiveStore
     */
    public function addToArchiveStore(\StructType\ArchiveStore $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArchiveStore) {
            throw new \InvalidArgumentException(sprintf('The ArchiveStore property can only contain items of type \StructType\ArchiveStore, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ArchiveStore[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArchiveStore|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArchiveStore|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArchiveStore|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArchiveStore|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArchiveStore|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArchiveStore
     */
    public function getAttributeName()
    {
        return 'ArchiveStore';
    }
}
