<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnreadDocument StructType
 * @subpackage Structs
 */
class UnreadDocument extends AbstractStructBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentID;
    /**
     * The SenderChairName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderChairName;
    /**
     * The SendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendDate;
    /**
     * The DocumentTopic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTopic;
    /**
     * Constructor method for UnreadDocument
     * @uses UnreadDocument::setDocumentID()
     * @uses UnreadDocument::setSenderChairName()
     * @uses UnreadDocument::setSendDate()
     * @uses UnreadDocument::setDocumentTopic()
     * @param int $documentID
     * @param string $senderChairName
     * @param string $sendDate
     * @param string $documentTopic
     */
    public function __construct($documentID = null, $senderChairName = null, $sendDate = null, $documentTopic = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setSenderChairName($senderChairName)
            ->setSendDate($sendDate)
            ->setDocumentTopic($documentTopic);
    }
    /**
     * Get DocumentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param int $documentID
     * @return \StructType\UnreadDocument
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get SenderChairName value
     * @return string|null
     */
    public function getSenderChairName()
    {
        return $this->SenderChairName;
    }
    /**
     * Set SenderChairName value
     * @param string $senderChairName
     * @return \StructType\UnreadDocument
     */
    public function setSenderChairName($senderChairName = null)
    {
        // validation for constraint: string
        if (!is_null($senderChairName) && !is_string($senderChairName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderChairName, true), gettype($senderChairName)), __LINE__);
        }
        $this->SenderChairName = $senderChairName;
        return $this;
    }
    /**
     * Get SendDate value
     * @return string|null
     */
    public function getSendDate()
    {
        return $this->SendDate;
    }
    /**
     * Set SendDate value
     * @param string $sendDate
     * @return \StructType\UnreadDocument
     */
    public function setSendDate($sendDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendDate) && !is_string($sendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendDate, true), gettype($sendDate)), __LINE__);
        }
        $this->SendDate = $sendDate;
        return $this;
    }
    /**
     * Get DocumentTopic value
     * @return string|null
     */
    public function getDocumentTopic()
    {
        return $this->DocumentTopic;
    }
    /**
     * Set DocumentTopic value
     * @param string $documentTopic
     * @return \StructType\UnreadDocument
     */
    public function setDocumentTopic($documentTopic = null)
    {
        // validation for constraint: string
        if (!is_null($documentTopic) && !is_string($documentTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTopic, true), gettype($documentTopic)), __LINE__);
        }
        $this->DocumentTopic = $documentTopic;
        return $this;
    }
}
