<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemProperty StructType
 * @subpackage Structs
 */
class SystemProperty extends AbstractStructBase
{
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjectId;
    /**
     * The Processor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Processor;
    /**
     * The OperatingSystem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingSystem;
    /**
     * The RAM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RAM;
    /**
     * The OfficeRelease
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficeRelease;
    /**
     * Constructor method for SystemProperty
     * @uses SystemProperty::setObjectId()
     * @uses SystemProperty::setProcessor()
     * @uses SystemProperty::setOperatingSystem()
     * @uses SystemProperty::setRAM()
     * @uses SystemProperty::setOfficeRelease()
     * @param int $objectId
     * @param string $processor
     * @param string $operatingSystem
     * @param string $rAM
     * @param string $officeRelease
     */
    public function __construct($objectId = null, $processor = null, $operatingSystem = null, $rAM = null, $officeRelease = null)
    {
        $this
            ->setObjectId($objectId)
            ->setProcessor($processor)
            ->setOperatingSystem($operatingSystem)
            ->setRAM($rAM)
            ->setOfficeRelease($officeRelease);
    }
    /**
     * Get ObjectId value
     * @return int
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param int $objectId
     * @return \StructType\SystemProperty
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: int
        if (!is_null($objectId) && !(is_int($objectId) || ctype_digit($objectId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get Processor value
     * @return string|null
     */
    public function getProcessor()
    {
        return $this->Processor;
    }
    /**
     * Set Processor value
     * @param string $processor
     * @return \StructType\SystemProperty
     */
    public function setProcessor($processor = null)
    {
        // validation for constraint: string
        if (!is_null($processor) && !is_string($processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processor, true), gettype($processor)), __LINE__);
        }
        $this->Processor = $processor;
        return $this;
    }
    /**
     * Get OperatingSystem value
     * @return string|null
     */
    public function getOperatingSystem()
    {
        return $this->OperatingSystem;
    }
    /**
     * Set OperatingSystem value
     * @param string $operatingSystem
     * @return \StructType\SystemProperty
     */
    public function setOperatingSystem($operatingSystem = null)
    {
        // validation for constraint: string
        if (!is_null($operatingSystem) && !is_string($operatingSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingSystem, true), gettype($operatingSystem)), __LINE__);
        }
        $this->OperatingSystem = $operatingSystem;
        return $this;
    }
    /**
     * Get RAM value
     * @return string|null
     */
    public function getRAM()
    {
        return $this->RAM;
    }
    /**
     * Set RAM value
     * @param string $rAM
     * @return \StructType\SystemProperty
     */
    public function setRAM($rAM = null)
    {
        // validation for constraint: string
        if (!is_null($rAM) && !is_string($rAM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rAM, true), gettype($rAM)), __LINE__);
        }
        $this->RAM = $rAM;
        return $this;
    }
    /**
     * Get OfficeRelease value
     * @return string|null
     */
    public function getOfficeRelease()
    {
        return $this->OfficeRelease;
    }
    /**
     * Set OfficeRelease value
     * @param string $officeRelease
     * @return \StructType\SystemProperty
     */
    public function setOfficeRelease($officeRelease = null)
    {
        // validation for constraint: string
        if (!is_null($officeRelease) && !is_string($officeRelease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officeRelease, true), gettype($officeRelease)), __LINE__);
        }
        $this->OfficeRelease = $officeRelease;
        return $this;
    }
}
