<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScannedImageProperties StructType
 * @subpackage Structs
 */
class ScannedImageProperties extends AbstractStructBase
{
    /**
     * The Resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resolution;
    /**
     * The Brightness
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Brightness;
    /**
     * The Contrast
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contrast;
    /**
     * The ScanMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanMode;
    /**
     * The ColorProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColorProfile;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * Constructor method for ScannedImageProperties
     * @uses ScannedImageProperties::setResolution()
     * @uses ScannedImageProperties::setBrightness()
     * @uses ScannedImageProperties::setContrast()
     * @uses ScannedImageProperties::setScanMode()
     * @uses ScannedImageProperties::setColorProfile()
     * @uses ScannedImageProperties::setDocumentType()
     * @param string $resolution
     * @param string $brightness
     * @param string $contrast
     * @param string $scanMode
     * @param string $colorProfile
     * @param string $documentType
     */
    public function __construct($resolution = null, $brightness = null, $contrast = null, $scanMode = null, $colorProfile = null, $documentType = null)
    {
        $this
            ->setResolution($resolution)
            ->setBrightness($brightness)
            ->setContrast($contrast)
            ->setScanMode($scanMode)
            ->setColorProfile($colorProfile)
            ->setDocumentType($documentType);
    }
    /**
     * Get Resolution value
     * @return string|null
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @param string $resolution
     * @return \StructType\ScannedImageProperties
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: string
        if (!is_null($resolution) && !is_string($resolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get Brightness value
     * @return string|null
     */
    public function getBrightness()
    {
        return $this->Brightness;
    }
    /**
     * Set Brightness value
     * @param string $brightness
     * @return \StructType\ScannedImageProperties
     */
    public function setBrightness($brightness = null)
    {
        // validation for constraint: string
        if (!is_null($brightness) && !is_string($brightness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brightness, true), gettype($brightness)), __LINE__);
        }
        $this->Brightness = $brightness;
        return $this;
    }
    /**
     * Get Contrast value
     * @return string|null
     */
    public function getContrast()
    {
        return $this->Contrast;
    }
    /**
     * Set Contrast value
     * @param string $contrast
     * @return \StructType\ScannedImageProperties
     */
    public function setContrast($contrast = null)
    {
        // validation for constraint: string
        if (!is_null($contrast) && !is_string($contrast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrast, true), gettype($contrast)), __LINE__);
        }
        $this->Contrast = $contrast;
        return $this;
    }
    /**
     * Get ScanMode value
     * @return string|null
     */
    public function getScanMode()
    {
        return $this->ScanMode;
    }
    /**
     * Set ScanMode value
     * @param string $scanMode
     * @return \StructType\ScannedImageProperties
     */
    public function setScanMode($scanMode = null)
    {
        // validation for constraint: string
        if (!is_null($scanMode) && !is_string($scanMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanMode, true), gettype($scanMode)), __LINE__);
        }
        $this->ScanMode = $scanMode;
        return $this;
    }
    /**
     * Get ColorProfile value
     * @return string|null
     */
    public function getColorProfile()
    {
        return $this->ColorProfile;
    }
    /**
     * Set ColorProfile value
     * @param string $colorProfile
     * @return \StructType\ScannedImageProperties
     */
    public function setColorProfile($colorProfile = null)
    {
        // validation for constraint: string
        if (!is_null($colorProfile) && !is_string($colorProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorProfile, true), gettype($colorProfile)), __LINE__);
        }
        $this->ColorProfile = $colorProfile;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \StructType\ScannedImageProperties
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
}
