<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saveDocumentTypeProfileValues StructType
 * @subpackage Structs
 */
class SaveDocumentTypeProfileValues extends AbstractStructBase
{
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The profileValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocumentTypeProfileValue
     */
    public $profileValues;
    /**
     * Constructor method for saveDocumentTypeProfileValues
     * @uses SaveDocumentTypeProfileValues::setDocumentID()
     * @uses SaveDocumentTypeProfileValues::setProfileValues()
     * @param int $documentID
     * @param \ArrayType\ArrayOfDocumentTypeProfileValue $profileValues
     */
    public function __construct($documentID = null, \ArrayType\ArrayOfDocumentTypeProfileValue $profileValues = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setProfileValues($profileValues);
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \StructType\SaveDocumentTypeProfileValues
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get profileValues value
     * @return \ArrayType\ArrayOfDocumentTypeProfileValue|null
     */
    public function getProfileValues()
    {
        return $this->profileValues;
    }
    /**
     * Set profileValues value
     * @param \ArrayType\ArrayOfDocumentTypeProfileValue $profileValues
     * @return \StructType\SaveDocumentTypeProfileValues
     */
    public function setProfileValues(\ArrayType\ArrayOfDocumentTypeProfileValue $profileValues = null)
    {
        $this->profileValues = $profileValues;
        return $this;
    }
}
