<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OranDocument StructType
 * @subpackage Structs
 */
class OranDocument extends AbstractStructBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentID;
    /**
     * The DocumentTopic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTopic;
    /**
     * The DocumentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNo;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentCreatorSicil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentCreatorSicil;
    /**
     * The DocumentCreatorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentCreatorName;
    /**
     * The DocumentTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeID;
    /**
     * The DocumentTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeName;
    /**
     * The Property
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Property;
    /**
     * Constructor method for OranDocument
     * @uses OranDocument::setDocumentID()
     * @uses OranDocument::setDocumentTopic()
     * @uses OranDocument::setDocumentNo()
     * @uses OranDocument::setDocumentDate()
     * @uses OranDocument::setDocumentCreatorSicil()
     * @uses OranDocument::setDocumentCreatorName()
     * @uses OranDocument::setDocumentTypeID()
     * @uses OranDocument::setDocumentTypeName()
     * @uses OranDocument::setProperty()
     * @param string $documentID
     * @param string $documentTopic
     * @param string $documentNo
     * @param string $documentDate
     * @param string $documentCreatorSicil
     * @param string $documentCreatorName
     * @param string $documentTypeID
     * @param string $documentTypeName
     * @param string $property
     */
    public function __construct($documentID = null, $documentTopic = null, $documentNo = null, $documentDate = null, $documentCreatorSicil = null, $documentCreatorName = null, $documentTypeID = null, $documentTypeName = null, $property = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setDocumentTopic($documentTopic)
            ->setDocumentNo($documentNo)
            ->setDocumentDate($documentDate)
            ->setDocumentCreatorSicil($documentCreatorSicil)
            ->setDocumentCreatorName($documentCreatorName)
            ->setDocumentTypeID($documentTypeID)
            ->setDocumentTypeName($documentTypeName)
            ->setProperty($property);
    }
    /**
     * Get DocumentID value
     * @return string|null
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param string $documentID
     * @return \StructType\OranDocument
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: string
        if (!is_null($documentID) && !is_string($documentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get DocumentTopic value
     * @return string|null
     */
    public function getDocumentTopic()
    {
        return $this->DocumentTopic;
    }
    /**
     * Set DocumentTopic value
     * @param string $documentTopic
     * @return \StructType\OranDocument
     */
    public function setDocumentTopic($documentTopic = null)
    {
        // validation for constraint: string
        if (!is_null($documentTopic) && !is_string($documentTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTopic, true), gettype($documentTopic)), __LINE__);
        }
        $this->DocumentTopic = $documentTopic;
        return $this;
    }
    /**
     * Get DocumentNo value
     * @return string|null
     */
    public function getDocumentNo()
    {
        return $this->DocumentNo;
    }
    /**
     * Set DocumentNo value
     * @param string $documentNo
     * @return \StructType\OranDocument
     */
    public function setDocumentNo($documentNo = null)
    {
        // validation for constraint: string
        if (!is_null($documentNo) && !is_string($documentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNo, true), gettype($documentNo)), __LINE__);
        }
        $this->DocumentNo = $documentNo;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \StructType\OranDocument
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentCreatorSicil value
     * @return string|null
     */
    public function getDocumentCreatorSicil()
    {
        return $this->DocumentCreatorSicil;
    }
    /**
     * Set DocumentCreatorSicil value
     * @param string $documentCreatorSicil
     * @return \StructType\OranDocument
     */
    public function setDocumentCreatorSicil($documentCreatorSicil = null)
    {
        // validation for constraint: string
        if (!is_null($documentCreatorSicil) && !is_string($documentCreatorSicil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCreatorSicil, true), gettype($documentCreatorSicil)), __LINE__);
        }
        $this->DocumentCreatorSicil = $documentCreatorSicil;
        return $this;
    }
    /**
     * Get DocumentCreatorName value
     * @return string|null
     */
    public function getDocumentCreatorName()
    {
        return $this->DocumentCreatorName;
    }
    /**
     * Set DocumentCreatorName value
     * @param string $documentCreatorName
     * @return \StructType\OranDocument
     */
    public function setDocumentCreatorName($documentCreatorName = null)
    {
        // validation for constraint: string
        if (!is_null($documentCreatorName) && !is_string($documentCreatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCreatorName, true), gettype($documentCreatorName)), __LINE__);
        }
        $this->DocumentCreatorName = $documentCreatorName;
        return $this;
    }
    /**
     * Get DocumentTypeID value
     * @return string|null
     */
    public function getDocumentTypeID()
    {
        return $this->DocumentTypeID;
    }
    /**
     * Set DocumentTypeID value
     * @param string $documentTypeID
     * @return \StructType\OranDocument
     */
    public function setDocumentTypeID($documentTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeID) && !is_string($documentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeID, true), gettype($documentTypeID)), __LINE__);
        }
        $this->DocumentTypeID = $documentTypeID;
        return $this;
    }
    /**
     * Get DocumentTypeName value
     * @return string|null
     */
    public function getDocumentTypeName()
    {
        return $this->DocumentTypeName;
    }
    /**
     * Set DocumentTypeName value
     * @param string $documentTypeName
     * @return \StructType\OranDocument
     */
    public function setDocumentTypeName($documentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeName) && !is_string($documentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeName, true), gettype($documentTypeName)), __LINE__);
        }
        $this->DocumentTypeName = $documentTypeName;
        return $this;
    }
    /**
     * Get Property value
     * @return string|null
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * Set Property value
     * @param string $property
     * @return \StructType\OranDocument
     */
    public function setProperty($property = null)
    {
        // validation for constraint: string
        if (!is_null($property) && !is_string($property)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($property, true), gettype($property)), __LINE__);
        }
        $this->Property = $property;
        return $this;
    }
}
