<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JMODocument StructType
 * @subpackage Structs
 */
class JMODocument extends AbstractStructBase
{
    /**
     * The DocumentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNo;
    /**
     * The DocumentTopic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTopic;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentLink;
    /**
     * Constructor method for JMODocument
     * @uses JMODocument::setDocumentNo()
     * @uses JMODocument::setDocumentTopic()
     * @uses JMODocument::setDocumentDate()
     * @uses JMODocument::setDocumentLink()
     * @param string $documentNo
     * @param string $documentTopic
     * @param string $documentDate
     * @param string $documentLink
     */
    public function __construct($documentNo = null, $documentTopic = null, $documentDate = null, $documentLink = null)
    {
        $this
            ->setDocumentNo($documentNo)
            ->setDocumentTopic($documentTopic)
            ->setDocumentDate($documentDate)
            ->setDocumentLink($documentLink);
    }
    /**
     * Get DocumentNo value
     * @return string|null
     */
    public function getDocumentNo()
    {
        return $this->DocumentNo;
    }
    /**
     * Set DocumentNo value
     * @param string $documentNo
     * @return \StructType\JMODocument
     */
    public function setDocumentNo($documentNo = null)
    {
        // validation for constraint: string
        if (!is_null($documentNo) && !is_string($documentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNo, true), gettype($documentNo)), __LINE__);
        }
        $this->DocumentNo = $documentNo;
        return $this;
    }
    /**
     * Get DocumentTopic value
     * @return string|null
     */
    public function getDocumentTopic()
    {
        return $this->DocumentTopic;
    }
    /**
     * Set DocumentTopic value
     * @param string $documentTopic
     * @return \StructType\JMODocument
     */
    public function setDocumentTopic($documentTopic = null)
    {
        // validation for constraint: string
        if (!is_null($documentTopic) && !is_string($documentTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTopic, true), gettype($documentTopic)), __LINE__);
        }
        $this->DocumentTopic = $documentTopic;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \StructType\JMODocument
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentLink value
     * @return string|null
     */
    public function getDocumentLink()
    {
        return $this->DocumentLink;
    }
    /**
     * Set DocumentLink value
     * @param string $documentLink
     * @return \StructType\JMODocument
     */
    public function setDocumentLink($documentLink = null)
    {
        // validation for constraint: string
        if (!is_null($documentLink) && !is_string($documentLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentLink, true), gettype($documentLink)), __LINE__);
        }
        $this->DocumentLink = $documentLink;
        return $this;
    }
}
